<?php
namespace Codexpert\CoDesigner_Pro;

use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Codexpert\CoDesigner\App\Controls\Group_Control_Gradient_Text;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;
use Elementor\Core\Kits\Documents\Tabs\Global_Colors;

class Pricing_Table_Regular extends Widget_Base {

	public $id;

	public function __construct( $data = [], $args = null ) {
	    parent::__construct( $data, $args );

	    $this->id = wcd_get_widget_id( __CLASS__ );
	    $this->widget = wcd_get_widget( $this->id );
        
        // Are we in debug mode?
        $min = defined( 'CODESIGNER_PRO_DEBUG' ) && CODESIGNER_PRO_DEBUG ? '' : '.min';

		wp_register_style( "codesigner-{$this->id}", plugins_url( "assets/css/style{$min}.css", __FILE__ ), [], '1.1' );
	}

	public function get_script_depends() {
		return [ "codesigner-{$this->id}" ];
	}

	public function get_style_depends() {
		return [ "codesigner-{$this->id}" ];
	}

	public function get_name() {
		return $this->id;
	}

	public function get_title() {
		return $this->widget['title'];
	}

	public function get_icon() {
		return $this->widget['icon'];
	}

	public function get_categories() {
		return $this->widget['categories'];
	}

	protected function register_controls() {

        /**
         * General controls
         */
        $this->start_controls_section(
            '_section_general',
            [
                'label'         => __( 'General', 'codesigner' ),
                'tab'           => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'is_featured',
            [
                'label'         => __( 'Is Featured?', 'codesigner' ),
                'type'          => Controls_Manager::SWITCHER,
                'label_on'      => __( 'Yes', 'codesigner' ),
                'label_off'     => __( 'No', 'codesigner' ),
                'return_value'  => 'yes',
                'default'       => 'no',
            ]
        );

        $this->add_control(
            'is_featured_text',
            [
                'label'         => __( 'Badge Text', 'codesigner' ),
                'type'          => Controls_Manager::TEXT,
                'default'       => __( 'Featured', 'codesigner' ),
                'placeholder'   => __( 'Type your title here', 'codesigner' ),
                'condition' => [
                    'is_featured' => 'yes'
                ],
            ]
        );

        $this->end_controls_section();

		/**
        * Pricing Content control
        */ 

		$this->start_controls_section(
            '_section_pricing',
            [
                'label' 		=> __( 'Price', 'codesigner-pro' ),
                'tab' 			=> Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'pricing_table_currency',
            [
                'label'         => __( 'Currency', 'codesigner-pro' ),
                'type'          => Controls_Manager::TEXT,
                'default'       => '$',
                'dynamic'       => [
                    'active' => true
                ]
            ]
        );

        $this->add_control(
            'pricing_table_currency_alignment',
            [
                'label' => __( 'Currency Alignment', 'codesigner-pro' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __( 'Left', 'codesigner-pro' ),
                        'icon' => 'eicon-h-align-left',
                    ],
                    'right' => [
                        'title' => __( 'Right', 'codesigner-pro' ),
                        'icon' => 'eicon-h-align-right',
                    ],
                ],
                'default' => 'left',
                'toggle' => true,
                'separator'=> 'after'
            ]
        );

        $this->add_control(
            'pricing_table_price',
            [
                'label' 		=> __( 'Amount', 'codesigner-pro' ),
                'type' 			=> Controls_Manager::TEXT,
                'default' 		=> '11.99',
                'dynamic' 		=> [
                    'active' => true
                ]
            ]
        );

        $this->add_control(
            'pricing_table_period',
            [
                'label' 		=> __( 'Period', 'codesigner-pro' ),
                'type' 			=> Controls_Manager::TEXT,
                'default' 		=> __( 'PER MONTH', 'codesigner-pro' ),
                'dynamic' 		=> [
                    'active' => true
                ]
            ]
        );      
        
        $this->add_control(
            'show_sale_price',
            [
                'label' => __( 'Show sale Price', 'codesigner-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'codesigner-pro' ),
                'label_off' => __( 'Hide', 'codesigner-pro' ),
                'return_value' => 'yes',
                'default' => '',
            ]
        );

        $this->add_control(
            'pricing_table_sale_price',
            [
                'label'         => __( 'sale Amount', 'codesigner-pro' ),
                'type'          => Controls_Manager::TEXT,
                'default'       => '9.99',
                'condition' => [
                    'show_sale_price' => 'yes'
                ],
                'dynamic'       => [
                    'active' => true
                ]
            ]
        );

        $this->end_controls_section();

        /**
         * Title & description content control
         */
        $this->start_controls_section(
            '_section_header',
            [
                'label'         => __( 'Title & Description', 'codesigner-pro' ),
                'tab'           => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'pricing_table_title',
            [
                'label'         => __( 'Title', 'codesigner-pro' ),
                'type'          => Controls_Manager::TEXT,
                'label_block'   => true,
                'default'       => __( 'Regular Plan', 'codesigner-pro' ),
            ]
        );

        $this->add_control(
            'show_plan_desc',
            [
                'label' => __( 'Show Description', 'codesigner-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'codesigner-pro' ),
                'label_off' => __( 'Hide', 'codesigner-pro' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'pricing_table_desc',
            [
                'label'         => __( 'Description', 'codesigner-pro' ),
                'type'          => Controls_Manager::TEXTAREA,
                'default'       => __( 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod', 'codesigner-pro' ),
                'condition' => [
                    'show_plan_desc' => 'yes'
                ],
                'dynamic'       => [
                    'active' => true
                ]
            ]
        );

        $this->end_controls_section();

        /**
        * Features content control
        */

        $this->start_controls_section(
            '_section_features',
            [
                'label'			 => __( 'Features', 'codesigner-pro' ),
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'pricing_table_features_text',
            [
                'label' 		=> __( 'Text', 'codesigner-pro' ),
                'type' 			=> Controls_Manager::TEXT,
                'default' 		=> __( 'Exciting Feature', 'codesigner-pro' ),
                'label_block'   => 'true',
                'dynamic' 		=> [
                    'active' => true
                ]
            ]
        );

        $repeater->add_control(
            'pricing_table_features_icon',
            [
                'label' 		=> __( 'Icon', 'codesigner-pro' ),
                'type' 			=> Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'default' 		=> [
                    'value' 	=> 'fas fa-check',
                    'library' 	=> 'fa-solid',
                ],
                'recommended' 	=> [
                    'fa-regular' => [
                        'check-square',
                        'window-close',
                    ],
                    'fa-solid' 	=> [
                        'check',
                        'times'
                    ]
                ]
            ]
        );

        $repeater->add_control(
            'icon_color',
            [
                'label' => __( 'Icon Color', 'codesigner-pro' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#000',
            ]
        );

        $repeater->add_control(
            'icon_hover_color',
            [
                'label' => __( 'Icon Hover Color', 'codesigner-pro' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
            ]
        );

        $this->add_control(
            'pricing_table_features',
            [
                'type' 			=> Controls_Manager::REPEATER,
                'fields' 		=> $repeater->get_controls(),
                'show_label' 	=> false,
                'default' 		=> [
                    [
                        'pricing_table_features_text' => __( 'Standard Feature', 'codesigner-pro' ),
                        'pricing_table_features_icon' => 'fas fa-check',
                    ],
                    [
                        'pricing_table_features_text' => __( 'Another Great Feature', 'codesigner-pro' ),
                        'pricing_table_features_icon' => 'fas fa-check',
                    ],
                    [
                        'pricing_table_features_text' => __( 'Obsolete Feature', 'codesigner-pro' ),
                        'pricing_table_features_icon' => 'fas fa-times',
                    ],
                    [
                        'pricing_table_features_text' => __( 'Extended Free Trial', 'codesigner-pro' ),
                        'pricing_table_features_icon' => 'fas fa-check',
                    ],
                ],
                'title_field' 	=> '{{{pricing_table_features_text}}}',
            ]
        );

        $this->end_controls_section();

        /**
        * Button content control
        */

        $this->start_controls_section(
            '_section_footer',
            [
                'label' 		=> __( 'Footer Button', 'codesigner-pro' ),
                'tab' 			=> Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'show_purchase_btn',
            [
                'label' => __( 'Show Button', 'codesigner-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'codesigner-pro' ),
                'label_off' => __( 'Hide', 'codesigner-pro' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'pricing_table_btn_text',
            [
                'label' 		=> __( 'Button Text', 'codesigner-pro' ),
                'type' 			=> Controls_Manager::TEXT,
                'default' 		=> __( 'Purchase', 'codesigner-pro' ),
                'placeholder' 	=> __( 'Type button text here', 'codesigner-pro' ),
                'label_block' 	=> true,
                'dynamic' 		=> [
                    'active' 	=> true
                ],
                'condition' => [
                    'show_purchase_btn' => 'yes'
                ],
            ]
        );

        $this->add_control(
            'pricing_table_btn_link',
            [
                'label' 		=> __( 'Link', 'codesigner-pro' ),
                'type' 			=> Controls_Manager::URL,
                'label_block' 	=> true,
                'placeholder' 	=> 'https://codexpert.io/codesigner/',
                'dynamic' 		=> [
                    'active' => true,
                ],   
                'condition' => [
                    'show_purchase_btn' => 'yes'
                ],             
            ]
        );

        $this->end_controls_section();

        /**
        *Full card styling
        */

        $this->start_controls_section(
            '_section_style_card',
            [
                'label' => __( 'Card', 'codesigner-pro' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs( 'pricing_table_card' );

        $this->start_controls_tab(
            'pricing_table_card_normal',
            [
                'label' => __( 'Normal', 'codesigner-pro' ),
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'pricing_table_box_bg',
                'label' => __( 'Background', 'codesigner-pro' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '.wl {{WRAPPER}} .wl-pricing-table-regular',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'pricing_table_card_hover',
            [
                'label' => __( 'Hover', 'codesigner-pro' ),
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'pricing_table_box_bg_hover',
                'label' => __( 'Background', 'codesigner-pro' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '.wl {{WRAPPER}} .wl-pricing-table-regular:hover',
            ]
        );

        $this->add_control(
            'pricing_table_box_bg_hover_transition',
            [
                'label'     => __( 'Transition Duration', 'codesigner-pro' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px'    => [
                        'max'   => 3,
                        'step'  => 0.1,
                    ],
                ],
                'selectors' => [
                    '.wl {{WRAPPER}} .wl-pricing-table-regular:hover .wl-ptr-pricing-area' => 'transition-duration: {{SIZE}}s',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'pricing_table_box_border',
                'label' => __( 'Border', 'codesigner-pro' ),
                'separator' => 'before',
                'selector' => '.wl {{WRAPPER}} .wl-pricing-table-regular',
            ]
        );

        $this->add_responsive_control(
            'pricing_table_box_border_radius',
            [
                'label'         => __( 'Border Radius', 'codesigner-pro' ),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => [ 'px', '%', 'em' ],
                'selectors'     => [
                    '.wl {{WRAPPER}} .wl-pricing-table-regular' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'pricing_table_box_shadow',
                'label' => __( 'Box Shadow', 'codesigner-pro' ),
                'selector' => '.wl {{WRAPPER}} .wl-pricing-table-regular',
            ]
        );


        $this->add_responsive_control(
            'pricing_table_box_padding',
            [
                'label'         => __( 'Padding', 'codesigner-pro' ),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => [ 'px', '%', 'em' ],
                'selectors'     => [
                    '.wl {{WRAPPER}} .wl-pricing-table-regular' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        /**
        *Is featured styling
        */

        $this->start_controls_section(
            '_section_style_featured',
            [
                'label' => __( 'Featured', 'codesigner-pro' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'is_featured' => 'yes'
                ],
            ]
        );

        $this->add_responsive_control(
            'featured_offset_y',
            [
                'label'         => __( 'Offset Top', 'codesigner' ),
                'type'          => Controls_Manager::SLIDER,
                'size_units'    => ['px'],
                'range'         => [
                    'px'        => [
                        'min'   => -1000,
                        'max'   => 1000,
                    ],
                ],
                'selectors'     => [
                    '.wl {{WRAPPER}} .wl-ptr-featured' => 'top: {{SIZE}}{{UNIT}}'
                ],
            ]
        );

        $this->add_responsive_control(
            'featured_offset_x',
            [
                'label'         => __( 'Offset Left', 'codesigner' ),
                'type'          => Controls_Manager::SLIDER,
                'size_units'    => ['px'],
                'range'         => [
                    'px'        => [
                        'min'   => -1000,
                        'max'   => 1000,
                    ],
                ],
                'selectors'     => [
                    '.wl {{WRAPPER}} .wl-ptr-featured' => 'left: {{SIZE}}{{UNIT}}'
                ],
            ]
        );

        $this->add_responsive_control(
            'featured_rotation',
            [
                'label'         => __( 'Rotation', 'codesigner' ),
                'type'          => Controls_Manager::SLIDER,
                'size_units'    => ['px'],
                'range'         => [
                    'px'        => [
                        'min'   => 0,
                        'max'   => 360,
                    ],
                ],
                'selectors'     => [
                    '.wl {{WRAPPER}} .wl-ptr-featured' => 'transform: rotate({{SIZE}}deg)'
                ],
            ]
        );

        $this->start_controls_tabs( 'pricing_table_featured' );

        $this->start_controls_tab(
            'pricing_table_featured_normal',
            [
                'label' => __( 'Normal', 'codesigner-pro' ),
            ]
        );

        $this->add_control(
            'featured_text_color',
            [
                'label' => __( 'Text Color', 'codesigner-pro' ),
                'type' => Controls_Manager::COLOR,
                'global' => [
                    'default' => Global_Colors::COLOR_PRIMARY,
                ],
                'selectors' => [
                    '.wl {{WRAPPER}} .wl-ptr-featured' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'pricing_table_featured_bg',
                'label' => __( 'Background', 'codesigner-pro' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '.wl {{WRAPPER}} .wl-ptr-featured',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'pricing_table_featured_hover',
            [
                'label' => __( 'Hover', 'codesigner-pro' ),
            ]
        );

        $this->add_control(
            'featured_text_color_hover',
            [
                'label' => __( 'Text Color', 'codesigner-pro' ),
                'type' => Controls_Manager::COLOR,
                'global' => [
                    'default' => Global_Colors::COLOR_PRIMARY,
                ],
                'selectors' => [
                    '.wl {{WRAPPER}} .wl-pricing-table-regular:hover .wl-ptr-featured' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'pricing_table_featured_bg_hover',
                'label' => __( 'Background', 'codesigner-pro' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '.wl {{WRAPPER}} .wl-pricing-table-regular:hover .wl-ptr-featured',
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'pricing_table_featured_border',
                'label' => __( 'Border', 'codesigner-pro' ),
                'separator' => 'before',
                'selector' => '.wl {{WRAPPER}} .wl-ptr-featured',
            ]
        );

        $this->add_responsive_control(
            'pricing_table_featured_border_radius',
            [
                'label'         => __( 'Border Radius', 'codesigner-pro' ),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => [ 'px', '%', 'em' ],
                'selectors'     => [
                    '.wl {{WRAPPER}} .wl-ptr-featured' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'pricing_table_featured_shadow',
                'label' => __( 'Box Shadow', 'codesigner-pro' ),
                'selector' => '.wl {{WRAPPER}} .wl-ptr-featured',
            ]
        );


        $this->add_responsive_control(
            'pricing_table_featured_padding',
            [
                'label'         => __( 'Padding', 'codesigner-pro' ),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => [ 'px', '%', 'em' ],
                'selectors'     => [
                    '.wl {{WRAPPER}} .wl-ptr-featured' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        /**
        *Regular Price styling
        */

        $this->start_controls_section(
            '_section_style_price',
            [
                'label' => __( 'Price', 'codesigner-pro' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'price_align',
            [
                'label' => __( 'Alignment', 'codesigner-pro' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __( 'Left', 'codesigner-pro' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', 'codesigner-pro' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __( 'Right', 'codesigner-pro' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'center',
                'toggle' => true,
                'selectors'     => [
                    '.wl {{WRAPPER}} .wl-pricing-table-regular .wl-ptr-regular-price' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'price_typography',
                'label'     => __( 'Typography', 'codesigner-pro' ),
                'global' => [
                    'default' => Global_Typography::TYPOGRAPHY_PRIMARY,
                ],
                'selector'  => '.wl {{WRAPPER}} .wl-pricing-table-regular .wl-ptr-regular-price ',
                'fields_options'    => [
                    'typography'    => [ 'default' => 'yes' ],
                    'font_family'   => [ 'default' => 'Nunito' ],
                ],
            ]
        );

        $this->start_controls_tabs( 'pricing_table_price_tab' );

        $this->start_controls_tab(
            'pricing_table_price_normal',
            [
                'label' => __( 'Normal', 'codesigner-pro' ),
            ]
        );

        $this->add_group_control(
            Group_Control_Gradient_Text::get_type(),
            [
                'name' => 'price_gradient_color',
                'selector' => '.wl {{WRAPPER}} .wl-pricing-table-regular .wl-ptr-regular-price ',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'pricing_table_price_hover',
            [
                'label' => __( 'Hover', 'codesigner-pro' ),
            ]
        );

        $this->add_group_control(
            Group_Control_Gradient_Text::get_type(),
            [
                'name' => 'price_gradient_color_hover',
                'selector' => '.wl {{WRAPPER}} .wl-pricing-table-regular:hover .wl-ptr-regular-price ',
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        /**
        *Sale Price styling
        */

        $this->start_controls_section(
            '_section_style_sale_price',
            [
                'label' => __( 'Sale Price', 'codesigner-pro' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_sale_price' => 'yes'
                ],
            ]
        );

        $this->add_control(
            'sale_price_align',
            [
                'label' => __( 'Alignment', 'codesigner-pro' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __( 'Left', 'codesigner-pro' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', 'codesigner-pro' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __( 'Right', 'codesigner-pro' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'center',
                'toggle' => true,
                'selectors'     => [
                    '.wl {{WRAPPER}} .wl-pricing-table-regular .wl-ptr-sale-price' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'sale_price_typography',
                'label'     => __( 'Typography', 'codesigner-pro' ),
                'global' => [
                    'default' => Global_Typography::TYPOGRAPHY_PRIMARY,
                ],
                'selector'  => '.wl {{WRAPPER}} .wl-pricing-table-regular .wl-ptr-sale-price ',
                'fields_options'    => [
                    'typography'    => [ 'default' => 'yes' ],
                    'font_family'   => [ 'default' => 'Nunito' ],
                ],
            ]
        );

        $this->start_controls_tabs( 'pricing_table_sale_price_tab' );

        $this->start_controls_tab(
            'pricing_table_sale_price_normal',
            [
                'label' => __( 'Normal', 'codesigner-pro' ),
            ]
        );

        $this->add_group_control(
            Group_Control_Gradient_Text::get_type(),
            [
                'name' => 'sale_price_gradient_color',
                'selector' => '.wl {{WRAPPER}} .wl-pricing-table-regular .wl-ptr-sale-price ',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'sale_pricing_table_price_hover',
            [
                'label' => __( 'Hover', 'codesigner-pro' ),
            ]
        );

        $this->add_group_control(
            Group_Control_Gradient_Text::get_type(),
            [
                'name' => 'sale_price_gradient_color_hover',
                'selector' => '.wl {{WRAPPER}} .wl-pricing-table-regular:hover .wl-ptr-sale-price ',
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        /**
        *Period Price styling
        */

        $this->start_controls_section(
            '_section_style_period',
            [
                'label' => __( 'Period', 'codesigner-pro' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'pricing_period_title_align',
            [
                'label' => __( 'Alignment', 'codesigner-pro' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __( 'Left', 'codesigner-pro' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', 'codesigner-pro' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __( 'Right', 'codesigner-pro' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'center',
                'toggle' => true,
                'selectors'     => [
                    '.wl {{WRAPPER}} .wl-pricing-table-regular .wl-ptr-pricing-period' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'period_typography',
                'label'     => __( 'Typography', 'codesigner-pro' ),
                'global' => [
                    'default' => Global_Typography::TYPOGRAPHY_PRIMARY,
                ],
                'selector'  => '.wl {{WRAPPER}} .wl-pricing-table-regular .wl-ptr-pricing-period',
                'fields_options'    => [
                    'typography'    => [ 'default' => 'yes' ],
                    'font_family'   => [ 'default' => 'Nunito' ],
                ],
            ]
        );

        $this->start_controls_tabs( 'pricing_table_period_tab' );

        $this->start_controls_tab(
            'pricing_table_period_normal',
            [
                'label' => __( 'Normal', 'codesigner-pro' ),
            ]
        );

        $this->add_group_control(
            Group_Control_Gradient_Text::get_type(),
            [
                'name' => 'period_gradient_color',
                'selector' => '.wl {{WRAPPER}} .wl-pricing-table-regular .wl-ptr-pricing-period',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'pricing_table_period_hover',
            [
                'label' => __( 'Hover', 'codesigner-pro' ),
            ]
        );

        $this->add_group_control(
            Group_Control_Gradient_Text::get_type(),
            [
                'name' => 'period_gradient_color_hover',
                'selector' => '.wl {{WRAPPER}} .wl-pricing-table-regular:hover .wl-ptr-pricing-period',
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        /**
        *Features Content styling
        */

        $this->start_controls_section(
            '_section_style_content',
            [
                'label' => __( 'Content Area', 'codesigner-pro' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'pricing_table_content_border',
                'label' => __( 'Border', 'codesigner-pro' ),
                'separator' => 'before',
                'selector' => '.wl {{WRAPPER}} .wl-pricing-table-regular .wl-ptr-feature-area',
            ]
        );

        $this->add_responsive_control(
            'pricing_table_content_border_radius',
            [
                'label'         => __( 'Border Radius', 'codesigner-pro' ),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => [ 'px', '%', 'em' ],
                'selectors'     => [
                    '.wl {{WRAPPER}} .wl-pricing-table-regular .wl-ptr-feature-area' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'pricing_table_content_shadow',
                'label' => __( 'Box Shadow', 'codesigner-pro' ),
                'selector' => '.wl {{WRAPPER}} .wl-pricing-table-regular .wl-ptr-feature-area',
            ]
        );


        $this->add_responsive_control(
            'pricing_table_content_padding',
            [
                'label'         => __( 'Padding', 'codesigner-pro' ),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => [ 'px', '%', 'em' ],
                'selectors'     => [
                    '.wl {{WRAPPER}} .wl-pricing-table-regular .wl-ptr-feature-area' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        /**
        *Title styling
        */

        $this->start_controls_section(
            '_section_style_title',
            [
                'label' => __( 'Title', 'codesigner-pro' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'title_typography',
                'label'     => __( 'Typography', 'codesigner-pro' ),
                'global' => [
                    'default' => Global_Typography::TYPOGRAPHY_PRIMARY,
                ],
                'selector'  => '.wl {{WRAPPER}} .wl-pricing-table-regular .wl-ptr-title',
                'fields_options'    => [
                    'typography'    => [ 'default' => 'yes' ],
                    'font_family'   => [ 'default' => 'Montserrat' ],
                ],
            ]
        );


        $this->add_control(
            'title_align',
            [
                'label' => __( 'Alignment', 'codesigner-pro' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __( 'Left', 'codesigner-pro' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', 'codesigner-pro' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __( 'Right', 'codesigner-pro' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'center',
                'toggle' => true,
                'selectors'     => [
                    '.wl {{WRAPPER}} .wl-pricing-table-regular .wl-ptr-title' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'title_padding',
            [
                'label' => __( 'Padding', 'codesigner-pro' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '.wl {{WRAPPER}} .wl-pricing-table-regular .wl-ptr-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'title_margin',
            [
                'label' => __( 'Margin', 'codesigner-pro' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '.wl {{WRAPPER}} .wl-pricing-table-regular .wl-ptr-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs( 'pricing_table_title_tab' );

        $this->start_controls_tab(
            'pricing_table_title_normal',
            [
                'label' => __( 'Normal', 'codesigner-pro' ),
            ]
        );

        $this->add_group_control(
            Group_Control_Gradient_Text::get_type(),
            [
                'name' => 'title_gradient_color',
                'selector' => '.wl {{WRAPPER}} .wl-pricing-table-regular .wl-ptr-title',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'pricing_table_title_hover',
            [
                'label' => __( 'Hover', 'codesigner-pro' ),
            ]
        );

        $this->add_group_control(
            Group_Control_Gradient_Text::get_type(),
            [
                'name' => 'title_gradient_color_hover',
                'selector' => '.wl {{WRAPPER}} .wl-pricing-table-regular:hover .wl-ptr-title',
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        /**
        *Description styling
        */

        $this->start_controls_section(
            '_section_style_description',
            [
                'label' => __( 'Description', 'codesigner-pro' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_plan_desc' => 'yes'
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'description_typography',
                'label'     => __( 'Typography', 'codesigner-pro' ),
                'global' => [
                    'default' => Global_Typography::TYPOGRAPHY_PRIMARY,
                ],
                'selector'  => '.wl {{WRAPPER}} .wl-pricing-table-regular .wl-ptr-description',
                'fields_options'    => [
                    'typography'    => [ 'default' => 'yes' ],
                    'font_family'   => [ 'default' => 'Nunito' ],
                ],
            ]
        );

        $this->add_control(
            'description_align',
            [
                'label' => __( 'Alignment', 'codesigner-pro' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __( 'Left', 'codesigner-pro' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', 'codesigner-pro' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'justify' => [
                        'title' => __( 'Justify', 'codesigner-pro' ),
                        'icon' => 'eicon-text-align-justify',
                    ],
                    'right' => [
                        'title' => __( 'Right', 'codesigner-pro' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'center',
                'toggle' => true,
                'selectors'     => [
                    '.wl {{WRAPPER}} .wl-pricing-table-regular .wl-ptr-description' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'description_padding',
            [
                'label' => __( 'Padding', 'codesigner-pro' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '.wl {{WRAPPER}} .wl-pricing-table-regular .wl-ptr-description' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'description_margin',
            [
                'label' => __( 'Margin', 'codesigner-pro' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '.wl {{WRAPPER}} .wl-pricing-table-regular .wl-ptr-description' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs( 'pricing_table_description_tab' );

        $this->start_controls_tab(
            'pricing_table_description_normal',
            [
                'label' => __( 'Normal', 'codesigner-pro' ),
            ]
        );

        $this->add_group_control(
            Group_Control_Gradient_Text::get_type(),
            [
                'name' => 'description_gradient_color',
                'selector' => '.wl {{WRAPPER}} .wl-pricing-table-regular .wl-ptr-description',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'pricing_table_description_hover',
            [
                'label' => __( 'Hover', 'codesigner-pro' ),
            ]
        );

        $this->add_group_control(
            Group_Control_Gradient_Text::get_type(),
            [
                'name' => 'description_gradient_color_hover',
                'selector' => '.wl {{WRAPPER}} .wl-pricing-table-regular:hover .wl-ptr-description',
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        /**
        *Feature list styling
        */

        $this->start_controls_section(
            '_section_style_features',
            [
                'label' => __( 'Features', 'codesigner-pro' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'Icon_default_design',
            [
                'label' => __( 'View', 'codesigner-pro' ),
                'type' => Controls_Manager::HIDDEN,
                'default' => 'traditional',
                'selectors' => [
                    '.wl {{WRAPPER}} .wl-pricing-table-regular .wl-ptrf-pricing-icon-svg' => 'width: 20px',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'features_typography',
                'label'     => __( 'Typography', 'codesigner-pro' ),
                'global' => [
                    'default' => Global_Typography::TYPOGRAPHY_PRIMARY,
                ],
                'selector'  => '.wl {{WRAPPER}} .wl-pricing-table-regular .wl-ptrf-desc',
                'fields_options'    => [
                    'typography'    => [ 'default' => 'yes' ],
                    'font_family'   => [ 'default' => 'Nunito' ],
                ],
            ]
        );

        $this->add_control(
            'icon_size',
            [
                'label' => __( 'Icon Size', 'codesigner-pro' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '.wl {{WRAPPER}} .wl-pricing-table-regular .wl-ptrf-icon' => 'font-size: {{SIZE}}{{UNIT}}',
                    '.wl {{WRAPPER}} .wl-pricing-table-regular .wl-ptrf-pricing-icon-svg' => 'width: {{SIZE}}{{UNIT}}',
                ],
            ]
        );

        $this->add_control(
            'features_align',
            [
                'label' => __( 'Alignment', 'codesigner-pro' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __( 'Left', 'codesigner-pro' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', 'codesigner-pro' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __( 'Right', 'codesigner-pro' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'center',
                'toggle' => true,
                'selectors'     => [
                    '.wl {{WRAPPER}} .wl-pricing-table-regular .wl-ptr-feature-list' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'space_btn_items',
            [
                'label' => __( 'Space Between Features', 'codesigner-pro' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 300,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '.wl {{WRAPPER}} .wl-pricing-table-regular .wl-ptr-featute' => 'margin: {{SIZE}}{{UNIT}} 0{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'featute_padding',
            [
                'label' => __( 'Padding', 'codesigner-pro' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '.wl {{WRAPPER}} .wl-pricing-table-regular .wl-ptr-feature-list' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'featute_margin',
            [
                'label' => __( 'Margin', 'codesigner-pro' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '.wl {{WRAPPER}} .wl-pricing-table-regular .wl-ptr-feature-list' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs( 'pricing_table_features_tab' );

        $this->start_controls_tab(
            'pricing_table_features_normal',
            [
                'label' => __( 'Normal', 'codesigner-pro' ),
            ]
        );

        $this->add_group_control(
            Group_Control_Gradient_Text::get_type(),
            [
                'name' => 'features_gradient_color',
                'selector' => '.wl {{WRAPPER}} .wl-pricing-table-regular .wl-ptrf-desc',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'pricing_table_features_hover',
            [
                'label' => __( 'Hover', 'codesigner-pro' ),
            ]
        );

        $this->add_group_control(
            Group_Control_Gradient_Text::get_type(),
            [
                'name' => 'features_gradient_color_hover',
                'selector' => '.wl {{WRAPPER}} .wl-pricing-table-regular:hover .wl-ptrf-desc',
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        /**
        *Button styling
        */

        $this->start_controls_section(
            '_section_style_btn',
            [
                'label' => __( 'Button', 'codesigner-pro' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_purchase_btn' => 'yes'
                ],
            ]
        );

        $this->add_control(
            'btn_default_design',
            [
                'label' => __( 'View', 'codesigner' ),
                'type' => Controls_Manager::HIDDEN,
                'default' => 'traditional',
                'selectors'     => [
                    '.wl {{WRAPPER}} .wl-pricing-table-regular .wl-ptr-purchase' => 'position:absolute;',
                ],
            ]
        );

        $this->add_responsive_control(
            'btn_width',
            [
                'label' => __( 'Width', 'codesigner-pro' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 500,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 94
                ],
                'selectors' => [
                    '.wl {{WRAPPER}} .wl-pricing-table-regular .wl-ptr-purchase' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'btn_position_x',
            [
                'label' => __( 'Position X', 'codesigner-pro' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 3
                ],
                'selectors' => [
                    '.wl {{WRAPPER}} .wl-pricing-table-regular .wl-ptr-purchase' => 'left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'btn_position_y',
            [
                'label' => __( 'Position Y', 'codesigner-pro' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 3
                ],
                'selectors' => [
                    '.wl {{WRAPPER}} .wl-pricing-table-regular .wl-ptr-purchase' => 'bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'btn_typography',
                'label'     => __( 'Typography', 'codesigner-pro' ),
                'global' => [
                    'default' => Global_Typography::TYPOGRAPHY_PRIMARY,
                ],
                'selector'  => '.wl {{WRAPPER}} .wl-pricing-table-regular .wl-ptr-purchase-btn',
                'fields_options'    => [
                    'typography'    => [ 'default' => 'yes' ],
                    'font_family'   => [ 'default' => 'Nunito' ],
                ],
            ]
        );

        $this->add_responsive_control(
            'pricing_table_btn_border_radius',
            [
                'label'         => __( 'Border Radius', 'codesigner-pro' ),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => [ 'px', '%', 'em' ],
                'selectors'     => [
                    '.wl {{WRAPPER}} .wl-pricing-table-regular .wl-ptr-purchase' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs( 'pricing_table_btn_tab' );

        $this->start_controls_tab(
            'pricing_table_btn_normal',
            [
                'label' => __( 'Normal', 'codesigner-pro' ),
            ]
        );

        $this->add_group_control(
            Group_Control_Gradient_Text::get_type(),
            [
                'name' => 'btn_gradient_color',
                'selector' => '.wl {{WRAPPER}} .wl-pricing-table-regular .wl-ptr-purchase-btn',
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'pricing_table_btn_bg',
                'label' => __( 'Background', 'codesigner-pro' ),
                'types' => [ 'classic', 'gradient' ],
                'separator' => 'before',
                'selector' => '.wl {{WRAPPER}} .wl-pricing-table-regular .wl-ptr-purchase',
            ]
        );

         $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'pricing_table_btn_border',
                'label' => __( 'Border', 'codesigner-pro' ),
                'selector' => '.wl {{WRAPPER}} .wl-pricing-table-regular .wl-ptr-purchase',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'pricing_table_btn_hover',
            [
                'label' => __( 'Hover', 'codesigner-pro' ),
            ]
        );

        $this->add_group_control(
            Group_Control_Gradient_Text::get_type(),
            [
                'name' => 'btn_gradient_color_hover',
                'selector' => '.wl {{WRAPPER}} .wl-pricing-table-regular:hover .wl-ptr-purchase-btn',
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'pricing_table_btn_bg_hover',
                'label' => __( 'Background', 'codesigner-pro' ),
                'types' => [ 'classic', 'gradient' ],
                'separator' => 'before',
                'selector' => '.wl {{WRAPPER}} .wl-pricing-table-regular:hover .wl-ptr-purchase',
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'pricing_table_btn_border_hover',
                'label' => __( 'Border', 'codesigner-pro' ),                
                'selector' => '.wl {{WRAPPER}} .wl-pricing-table-regular:hover .wl-ptr-purchase',
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_responsive_control(
            'pricing_table_btn_padding',
            [
                'label'         => __( 'Padding', 'codesigner-pro' ),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => [ 'px', '%', 'em' ],
                'separator' => 'before',
                'selectors'     => [
                    '.wl {{WRAPPER}} .wl-pricing-table-regular .wl-ptr-purchase' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'pricing_table_btn_margin',
            [
                'label'         => __( 'Margin', 'codesigner-pro' ),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => [ 'px', '%', 'em' ],
                'selectors'     => [
                    '.wl {{WRAPPER}} .wl-pricing-table-regular .wl-ptr-purchase' => 'Margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
	}

	protected function render() {

		$settings = $this->get_settings_for_display();
        extract( $settings );

        $del_start = '';
        $del_close = '';
        $sale_price_on = '';

        if ( $show_sale_price == 'yes' ) {
            $del_start = '<del>';
            $del_close = '</del>';
            $sale_price_on = 'wl-ptr-sale-on';
        }
        $pt_featured = $is_featured == 'yes' ? 'wl-ptr-featured-on' : '';

        $this->render_editing_attributes();
        ?>

        <div class="wl-pricing-table-regular <?php echo esc_attr( $pt_featured ); ?>">
            <?php if( 'yes' == $is_featured ): ?>
                <span class="wl-ptr-featured <?php #echo esc_attr( $feature_alignment ); ?>"><?php echo esc_html( $is_featured_text ); ?></span>
            <?php endif; ?>
            <div class="wl-ptr-pricing-area">
                <div class="wl-ptr-price-area">
                    <?php if( 'left' == $pricing_table_currency_alignment ): ?>
                        <div class="wl-ptr-regular-price <?php echo esc_attr( $sale_price_on ); ?>">
                            <?php echo $del_start; ?><span class="wl-ptr-currency"><?php echo esc_html( $pricing_table_currency ); ?></span><?php 
                                printf( '<span %s>%s</span>',
                                    $this->get_render_attribute_string( 'pricing_table_price' ),
                                    esc_html( $pricing_table_price )
                                );
                                echo $del_close; 
                            ?>

                        </div>
                        <?php if( 'yes' == $show_sale_price ): ?>
                            <div class="wl-ptr-sale-price">
                                <span class="wl-ptr-currency"><?php echo esc_html( $pricing_table_currency ); ?></span><?php 
                                    printf( '<span %s>%s</span>',
                                        $this->get_render_attribute_string( 'pricing_table_sale_price' ),
                                        esc_html( $pricing_table_sale_price )
                                    );
                                ?>
                            </div>
                        <?php endif;

                        elseif( 'right' == $pricing_table_currency_alignment ): ?>
                        <div class="wl-ptr-regular-price <?php esc_attr_e( $sale_price_on ); ?>">
                            <?php 
                                echo $del_start; 
                                printf( '<span %s>%s</span>',
                                    $this->get_render_attribute_string( 'pricing_table_price' ),
                                    esc_html( $pricing_table_price )
                                );
                            ?><span class="wl-ptr-currency"><?php echo esc_html( $pricing_table_currency ); ?></span><?php echo $del_close; ?>
                        </div>
                        <?php if( 'yes' == $show_sale_price ): ?>
                            <div class="wl-ptr-sale-price">
                                <?php 
                                    printf( '<span %s>%s</span>',
                                        $this->get_render_attribute_string( 'pricing_table_sale_price' ),
                                        esc_html( $pricing_table_sale_price )
                                    );
                                ?><span class="wl-ptr-currency"><?php echo esc_html( $pricing_table_currency ); ?></span>
                            </div>
                        <?php endif;
                    endif; ?>
                </div>
                
                <?php 
                    printf( '<div %s>%s</div>',
                        $this->get_render_attribute_string( 'pricing_table_period' ),
                        esc_html( $pricing_table_period )
                    );
                ?>

            </div>
            <div class="wl-ptr-feature-area">

                <?php 

                    printf( '<h3 %s>%s</h3>',
                        $this->get_render_attribute_string( 'pricing_table_title' ),
                        esc_html( $pricing_table_title )
                    );

                if( 'yes' == $show_plan_desc ):

                    printf( '<p %s>%s</p>',
                        $this->get_render_attribute_string( 'pricing_table_desc' ),
                        esc_html( $pricing_table_desc )
                    );

                endif; 
                ?>
                <ul class="wl-ptr-feature-list">                   
                    <?php 
                    $section_id = $this->get_id();
                    $styling = '';
                    if( count( $pricing_table_features ) > 0 ): 
                            foreach ($pricing_table_features as $key => $feature):
                                $styling .= ".wl .wl-ptrf-icon-{$section_id}{$feature['_id']}{color: {$feature['icon_color']}} .wl .wl-pricing-table-regular:hover .wl-ptrf-icon-{$section_id}{$feature['_id']}{color: {$feature['icon_hover_color']}}";
                        ?>
                        <li class="wl-ptr-featute">
                            <span class="wl-ptrf-icon wl-ptrf-icon-<?php esc_attr_e( $section_id.$feature['_id'] ) ?>"><?php 
                                if ( $feature['pricing_table_features_icon']['library'] == 'svg' ) {
                                    $svg = esc_url( $feature['pricing_table_features_icon']['value']['url'] );
                                    echo "<img class='wl-ptrf-pricing-icon-svg' src='{$svg}' />";
                                }
                                else{
                                    $icon = esc_attr( $feature['pricing_table_features_icon']['value'] );
                                    echo "<i class='{$icon}'></i>";
                                }
                             ?></span>
                            <span class="wl-ptrf-desc"><?php echo esc_html( $feature['pricing_table_features_text'] ) ?></span>
                        </li>
                    <?php endforeach; endif; ?>
                </ul>
                <?php if( 'yes' == $show_purchase_btn ): ?>
                    <div class="wl-ptr-purchase">

                        <?php 
                            printf( '<a %s>%s</a>',
                                $this->get_render_attribute_string( 'pricing_table_btn_text' ),
                                esc_html( $pricing_table_btn_text )
                            );
                        ?>

                    </div>
                <?php endif; ?>
            </div>
        </div>
        <style type="text/css">
            <?php echo $styling; ?>
        </style>

		<?php

        do_action( 'codesigner_after_main_content', $this );
	}

    protected function render_editing_attributes() {
        $settings = $this->get_settings_for_display();
        extract( $settings );

        $this->add_inline_editing_attributes( 'pricing_table_price', 'none' );
        $this->add_render_attribute( 'pricing_table_price', 'class', 'wl-ptr-price' );

        $this->add_inline_editing_attributes( 'pricing_table_sale_price', 'none' );
        $this->add_render_attribute( 'pricing_table_sale_price', 'class', 'wl-ptr-price' );

        $this->add_inline_editing_attributes( 'pricing_table_period', 'none' );
        $this->add_render_attribute( 'pricing_table_period', 'class', 'wl-ptr-pricing-period' );

        $this->add_inline_editing_attributes( 'pricing_table_title', 'none' );
        $this->add_render_attribute( 'pricing_table_title', 'class', 'wl-ptr-title' );

        $this->add_inline_editing_attributes( 'pricing_table_desc', 'none' );
        $this->add_render_attribute( 'pricing_table_desc', 'class', 'wl-ptr-description' );

        $this->add_inline_editing_attributes( 'pricing_table_btn_text', 'none' );
        $this->add_render_attribute( 'pricing_table_btn_text', 'class', 'wl-ptr-purchase-btn' );

        if ( 'yes' == $show_purchase_btn ) {
            $btn_url    = esc_url( $pricing_table_btn_link['url'] );
            $target     = $pricing_table_btn_link['is_external'] ? '_blank' : '';
            $nofollow   = $pricing_table_btn_link['nofollow'] ? 'nofollow' : '';
            $this->add_render_attribute( 'pricing_table_btn_text', 'href', $btn_url );
            $this->add_render_attribute( 'pricing_table_btn_text', 'target', $target );
            $this->add_render_attribute( 'pricing_table_btn_text', 'rel', $nofollow );
        }
    }
}