jQuery(function($){
	
	function cart_the_hide(){
		$('.wl-floating-icon').show( 'slow' )
		$(".wl-floating-cart").hide( 'slow', 'linear' );
		$('.wl-floating-cart').parent().removeClass( 'wl-overlay' );
	}

	let cart_open = false;
	$(document).on('click','.wl-floating-cart-icon',function(e){
		e.preventDefault();	
		cart_the_hide();
		cart_open = false;

	});

	$( '.wl-floating-icon' ).on( 'click', function(){
		$('.wl-floating-icon').hide( 'slow' )
		$(".wl-floating-cart").show( 'slow' );
		$('.wl-floating-cart').parent().addClass( 'wl-overlay' );
		cart_open = true;	
	});

	document.addEventListener("keydown", function(event) {
		if ( event.keyCode === 27  && cart_open == true ) {
			cart_the_hide();
		}
    });

    $(document).on('added_to_cart', function( event, fragments, cart_hash, $button ) {

		let html 			= $.parseHTML( fragments['wl-checkout-amount'] );
		let quantity 		= fragments['wl-cart-quentity'];
		let products 		= fragments['wl-cart-product'];

		$( '.wl-floating-cart-footer' ).replaceWith( html );
		$( '.wl-floating-cart-table' ).empty().append( products );
		$( '.wl-floating-cart-product-no' ).empty().append( quantity );
		$('.wl-floating-icon').show( 'slow' );

		var flyToCartImg 	= $button.parents(".product").find("img:visible");
		var targetCart 		= $('.wl-floating-icon');

		if ( flyToCartImg ) {
			flyToCartImg.clone()
				.offset({
				top: flyToCartImg.offset().top,
				left: flyToCartImg.offset().left
			}).css({
					'opacity': '1',
					'position': 'absolute',
					'height': flyToCartImg.height() /2,
					'width': flyToCartImg.width() /2,
					'z-index': '100'
			}).appendTo($('body'))
			.animate({
					'top': targetCart.offset().top + 10,
					'left': targetCart.offset().left + 15,
					'height': flyToCartImg.height() /2,
					'width': flyToCartImg.width() /2
			}, 1000 ,
			function () {
				$(this).detach()
			} );
		}
	});

	// OnClick Remove Cart Item
	$(document).on( 'click', '.wl-fc-remove', function(e) {
		e.preventDefault();
		const dataKey = $(this).closest('tr').data('key');

		$.ajax({
			url: CODESIGNER_PRO.ajaxurl,
			data: { 'action':'co-remove-item', 'data-key' : dataKey, '_wpnonce' : CODESIGNER_PRO._nonce },
			type: 'POST',
			dataType: 'JSON',
			success: function(resp) {
				if( resp.status == 1 ) {
					$( '.wl-floating-product' ).filter(`[data-key=${dataKey}]`).remove();
					$( '.wl-amount' ).empty().append( resp.total );
					$( '.wl-floating-cart-product-no' ).empty().append( resp.quantity );
					if ( resp.total == '' ) {
						$('.wl-floating-cart-body').append( resp.message );
					}	
				}
			},
			error: function( resp ) {
	 			console.log(resp);
	 		}
		})
	});	

	// cart product quantatity change
	$(document).on( 'click', '.wl-floating-quantity-col', function(e) {
		e.preventDefault();
		const dataKey 		= $(this).closest('tr').data('key');
		const actionType 	= $(this).data('action');
		$.ajax({
			url: CODESIGNER_PRO.ajaxurl,
			data: { 'action':'wl-quantatity-change', 'data-key' : dataKey, '_wpnonce' : CODESIGNER_PRO._nonce, 'action-type' : actionType },
			type: 'POST',
			dataType: 'JSON',
			success: function(resp) {
				if( resp.status == 1 ) {
					$('.wl-amount').empty().append( resp.total );
					$( '.wl-floating-cart-product-no' ).empty().append( resp.quantity );
	 				$( '.wl-floating-price' ).filter(`[data-key=${dataKey}]`).empty().append( '$' +resp.single_price );
	 				$( '.wl-fc-input-text' ).filter(`[data-key=${dataKey}]`).val(resp.single_quantity);
	 				if ( resp.remove_product == true ) {
						$('.wl-floating-product').filter(`[data-key=${dataKey}]`).remove();
					}
					if ( resp.total == '' ) {
						$('.wl-floating-cart-body').append( resp.message );
					}			 										 									
				}
			},
			error: function( resp ) {
	 			console.log(resp);
	 		}
		})
	});
	// appy coupon on the cart
	$(document).on( 'click', '#co_apply_coupon', function(e) {
		e.preventDefault();
		var couponCode = $('#co_coupon_code').val();
		$.ajax({
			url: CODESIGNER_PRO.ajaxurl,
			data: { 'action':'co-apply-coupon', 'coupon-code' : couponCode, '_wpnonce' : CODESIGNER_PRO._nonce },
			type: 'POST',
			dataType: 'JSON',
			success: function(resp) {
				if( resp.status == 1 ) {
					$('.wl-amount').empty().append( resp.total );
					$('.coupon-applied-div').show(); 									
					$('.coupon-applied-div').text(resp.message); 									
				}
			},
			error: function( resp ) {
	 			console.log(resp);
	 		}
		})
	});				
});