<?php
use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Text_Stroke;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit; 
}

class Invoice_Builder_Widget extends Widget_Base {

	public function get_name() {
		return 'invoice_builder_widget';
	}

	public function get_title() {
		return esc_html__( 'CoDesigner Invoice', 'codesigner-pro' );
	}

	public function get_icon() {
		$cd_branding_class = ' wlbi';
		return 'eicon-document-file' . $cd_branding_class;
	}

	public function get_categories() {
		return [ 'codesigner' ];
	}

	public function get_keywords() {
		return [ 'invoice', 'builder', 'template', 'file', 'document', 'design' ];
	}

    protected function register_controls() {
        /**
		 * content section
		 */
		$this->start_controls_section(
			'cd_invoice_content',
			[
				'label' 	=> __( 'Template', 'codesigner-pro' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
			'cd_invoice_template',
			[
				'label'         => esc_html__( 'Select Template', 'codesigner-pro' ),
				'type'          => Controls_Manager::SELECT2,
				'label_block'   => true,
				'multiple'      => false,
				'options'       => [
					'template-1'    => esc_html__( 'Template 1', 'codesigner-pro' ),
					'template-2'    => esc_html__( 'Template 2', 'codesigner-pro' ),
					'template-3'    => esc_html__( 'Template 3', 'codesigner-pro' ),
				],
				'default'       => 'template-1',
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
			'cd_invoice_logo',
			[
				'label' 	=> __( 'Logo', 'codesigner-pro' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
			'cd_template_logo',
			[
				'label'     => esc_html__( 'Choose Logo', 'codesigner-pro' ),
				'type'      => Controls_Manager::MEDIA,
				'default'   => [
					'url'   => Utils::get_placeholder_image_src(),
				],
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
			'cd_title_section',
			[
				'label'     => esc_html__( 'Title', 'codesigner-pro' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'cd_invoice_title',
			[
				'label'         => esc_html__( 'Title', 'codesigner-pro' ),
				'type'          => Controls_Manager::TEXT,
				'default'       => esc_html__( 'Invoice', 'codesigner-pro' ),
				'placeholder'   => esc_html__( 'Type your title here', 'codesigner-pro' ),
			]
		);

		$this->end_controls_section();

        $this->start_controls_section(
			'cd_thank_you_section',
			[
				'label'     => esc_html__( 'Message', 'codesigner-pro' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
			'cd_show_thank_you',
			[
				'label'         => esc_html__( 'Show Message', 'codesigner-pro' ),
				'type'          => Controls_Manager::SWITCHER,
				'label_on'      => esc_html__( 'Show', 'codesigner-pro' ),
				'label_off'     => esc_html__( 'Hide', 'codesigner-pro' ),
				'return_value'  => 'yes',
				'default'       => 'yes',
			]
		);

		$this->add_control(
			'cd_thank_you_msg',
			[
				'label'         => esc_html__( 'Message', 'codesigner-pro' ),
				'type'          => Controls_Manager::TEXTAREA,
				'rows'          => 5,
				'default'       => esc_html__( 'Thank you for placing your order in our website.', 'codesigner-pro' ),
				'placeholder'   => esc_html__( 'Type your message here...', 'codesigner-pro' ),
			]
		);

		$this->end_controls_section();

        $this->start_controls_section(
			'cd_billing_section',
			[
				'label'     => esc_html__( 'Billing', 'codesigner-pro' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
			'cd_show_billing',
			[
				'label'         => esc_html__( 'Show Billing Info', 'codesigner-pro' ),
				'type'          => Controls_Manager::SWITCHER,
				'label_on'      => esc_html__( 'Show', 'codesigner-pro' ),
				'label_off'     => esc_html__( 'Hide', 'codesigner-pro' ),
				'return_value'  => 'yes',
				'default'       => 'yes',
			]
		);

		$this->add_control(
			'cd_billing_title',
			[
				'label'         => esc_html__( 'Title', 'codesigner-pro' ),
				'type'          => Controls_Manager::TEXT,
				'default'       => esc_html__( 'Billing Address', 'codesigner-pro' ),
				'placeholder'   => esc_html__( 'Type your title here...', 'codesigner-pro' ),
			]
		);

		$this->end_controls_section();

        $this->start_controls_section(
			'cd_shipping_section',
			[
				'label'     => esc_html__( 'Shipping', 'codesigner-pro' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
			'cd_show_shipping',
			[
				'label'         => esc_html__( 'Show Shipping Info', 'codesigner-pro' ),
				'type'          => Controls_Manager::SWITCHER,
				'label_on'      => esc_html__( 'Show', 'codesigner-pro' ),
				'label_off'     => esc_html__( 'Hide', 'codesigner-pro' ),
				'return_value'  => 'yes',
				'default'       => 'yes',
			]
		);

		$this->add_control(
			'cd_shipping_title',
			[
				'label'         => esc_html__( 'Title', 'codesigner-pro' ),
				'type'          => Controls_Manager::TEXT,
				'default'       => esc_html__( 'Shipping Address', 'codesigner-pro' ),
				'placeholder'   => esc_html__( 'Type your title here...', 'codesigner-pro' ),
			]
		);

		$this->end_controls_section();

		/**
		 * style section
		 */
		$this->start_controls_section(
			'cd_invoice_logo_style_section',
			[
				'label'      => __( 'Logo', 'codesigner-pro' ),
				'tab'        => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'cd_invoice_logo_width',
			[
				'label'         => esc_html__( 'Width', 'codesigner-pro' ),
				'type'          => Controls_Manager::SLIDER,
				'size_units'    => [ 'px', '%' ],
				'range'         => [
					'px'        => [
						'min'   => 0,
						'max'   => 300,
						'step'  => 1,
					],
					'%'         => [
						'min'   => 0,
						'max'   => 100,
					],
				],
				'default'       => [
					'unit'      => 'px',
					'size'      => 200,
				],
				'selectors'     => [
					'{{WRAPPER}} .cd-invoice-container-template-1 .cd-header .cd-company-logo img' => 'width: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .cd-invoice-container-template-2 .cd-header .cd-company-logo img' => 'width: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .cd-invoice-container-template-3 .cd-header .cd-company-logo img' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'cd_invoice_logo_height',
			[
				'label'         => esc_html__( 'Height', 'codesigner-pro' ),
				'type'          => Controls_Manager::SLIDER,
				'size_units'    => [ 'px', '%' ],
				'range'         => [
					'px'        => [
						'min'   => 0,
						'max'   => 150,
						'step'  => 1,
					],
					'%'         => [
						'min'   => 0,
						'max'   => 100,
					],
				],
				'default'       => [
					'unit'      => 'px',
					'size'      => 45,
				],
				'selectors'     => [
					'{{WRAPPER}} .cd-invoice-container-template-1 .cd-header .cd-company-logo img' => 'height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .cd-invoice-container-template-2 .cd-header .cd-company-logo img' => 'height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .cd-invoice-container-template-3 .cd-header .cd-company-logo img' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'cd_invoice_title_style_section',
			[
                'label'      => __( 'Title', 'codesigner-pro' ),
				'tab'        => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'      => 'cd_invoice_title_typography',
				'selector'  => '{{WRAPPER}} .cd-invoice-container-template-1 .cd-header .cd-title , 
								{{WRAPPER}} .cd-invoice-container-template-2 .cd-header .cd-title ,
								{{WRAPPER}} .cd-invoice-container-template-3 .cd-header .cd-title',
			]
		);

        $this->add_control(
			'cd_invoice_title_color',
			[
				'label'     => esc_html__( 'Title Color', 'codesigner-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .cd-invoice-container-template-1 .cd-header .cd-title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .cd-invoice-container-template-2 .cd-header .cd-title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .cd-invoice-container-template-3 .cd-header .cd-title' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' 		=> 'cd_invoice_title_bg',
				'types' 	=> [ 'classic', 'gradient' ],
				'selector' 	=> '{{WRAPPER}} .cd-invoice-container-template-2 .cd-header .cd-title',
				'condition' => [
					'cd_invoice_template' => 'template-2',
				],
			]
		);

        $this->add_group_control(
			Group_Control_Text_Stroke::get_type(),
			[
				'name'      => 'cd_invoice_title_stroke',
				'selector'  => '{{WRAPPER}} .cd-invoice-container-template-1 .cd-header .cd-title ,
								{{WRAPPER}} .cd-invoice-container-template-2 .cd-header .cd-title ,
								{{WRAPPER}} .cd-invoice-container-template-3 .cd-header .cd-title',
			]
		);

        $this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' 		=> 'cd_invoice_title_shadow',
				'selector' 	=> '{{WRAPPER}} .cd-invoice-container-template-1 .cd-header .cd-title ,
								{{WRAPPER}} .cd-invoice-container-template-2 .cd-header .cd-title ,
								{{WRAPPER}} .cd-invoice-container-template-3 .cd-header .cd-title',
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'cd_invoice_msg_style_section',
			[
                'label'      => __( 'Message', 'codesigner-pro' ),
				'tab'        => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'      => 'cd_invoice_msg_typography',
				'selector'  => '{{WRAPPER}} .cd-invoice-container-template-1 .cd-intro .cd-msg , 
								{{WRAPPER}} .cd-invoice-container-template-2 .cd-intro .cd-msg ,
								{{WRAPPER}} .cd-invoice-container-template-3 .cd-company-logo table .cd-msg td',
			]
		);

        $this->add_control(
			'cd_invoice_msg_color',
			[
				'label'     => esc_html__( 'Message Color', 'codesigner-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .cd-invoice-container-template-1 .cd-intro .cd-msg' 					=> 'color: {{VALUE}}',
					'{{WRAPPER}} .cd-invoice-container-template-2 .cd-intro .cd-msg' 					=> 'color: {{VALUE}}',
					'{{WRAPPER}} .cd-invoice-container-template-3 .cd-company-logo table .cd-msg td' 	=> 'color: {{VALUE}}',
				],
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'cd_invoice_order_style_section',
			[
                'label'      => __( 'Order Info', 'codesigner-pro' ),
				'tab'        => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'      => 'cd_invoice_order_number_typography',
				'selector'  => '{{WRAPPER}} .cd-invoice-container-template-1 .cd-intro .cd-order-info , 
								{{WRAPPER}} .cd-invoice-container-template-2 .cd-intro .cd-order-info,
								{{WRAPPER}} .cd-invoice-container-template-3 .cd-additional-info .cd-order-info',
			]
		);

        $this->add_control(
			'cd_invoice_order_number_color',
			[
				'label'     => esc_html__( 'Text Color', 'codesigner-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .cd-invoice-container-template-1 .cd-intro .cd-order-info' 			=> 'color: {{VALUE}}',
					'{{WRAPPER}} .cd-invoice-container-template-2 .cd-intro .cd-order-info' 			=> 'color: {{VALUE}}',
					'{{WRAPPER}} .cd-invoice-container-template-3 .cd-additional-info .cd-order-info' 	=> 'color: {{VALUE}}',
				],
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'cd_invoice_products_style_section',
			[
                'label'      => __( 'Products Details', 'codesigner-pro' ),
				'tab'        => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs(
            'cd_invoice_products_style_tabs'
        );

        $this->start_controls_tab(
            'cd_invoice_table_header_style_tab',
            [
                'label'     => esc_html__( 'Table Header', 'codesigner-pro' ),
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'      => 'cd_invoice_table_header_typography',
				'selector'  => '{{WRAPPER}} .cd-invoice-container-template-1 .cd-item-details .cd-list-table th ,
								{{WRAPPER}} .cd-invoice-container-template-2 .cd-item-details .cd-list-table th ,
								{{WRAPPER}} .cd-invoice-container-template-3 .cd-item-details .cd-list-table th',
			]
		);

        $this->add_control(
			'cd_invoice_table_header_color',
			[
				'label'     => esc_html__( 'Text Color', 'codesigner-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .cd-invoice-container-template-1 .cd-item-details .cd-list-table thead tr th' => 'color: {{VALUE}}',
					'{{WRAPPER}} .cd-invoice-container-template-2 .cd-item-details .cd-list-table thead tr th' => 'color: {{VALUE}}',
					'{{WRAPPER}} .cd-invoice-container-template-3 .cd-item-details .cd-list-table thead tr th' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' 		=> 'cd_invoice_table_header_bg',
				'types' 	=> [ 'classic', 'gradient' ],
				'selector' 	=> '{{WRAPPER}} .cd-invoice-container-template-2 .cd-item-details .cd-list-table thead th ,
								{{WRAPPER}} .cd-invoice-container-template-3 .cd-item-details .cd-list-table thead th',
				'condition' => [
					'cd_invoice_template' => ['template-2', 'template-3'],
				],
			]
		);

        $this->end_controls_tab();

        $this->start_controls_tab(
            'cd_invoice_table_body_style_tab',
            [
                'label'     => esc_html__( 'Table Body', 'codesigner-pro' ),
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'      => 'cd_invoice_table_body_typography',
				'selector'  => '{{WRAPPER}} .cd-invoice-container-template-1 .cd-item-details .cd-list-table td ,
								{{WRAPPER}} .cd-invoice-container-template-2 .cd-item-details .cd-list-table td ,
								{{WRAPPER}} .cd-invoice-container-template-3 .cd-item-details .cd-list-table td',
			]
		);

        $this->add_control(
			'cd_invoice_table_body_color',
			[
				'label'     => esc_html__( 'Text Color', 'codesigner-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .cd-invoice-container-template-1 .cd-item-details .cd-list-table tbody tr td' => 'color: {{VALUE}}',
					'{{WRAPPER}} .cd-invoice-container-template-2 .cd-item-details .cd-list-table tbody tr td' => 'color: {{VALUE}}',
					'{{WRAPPER}} .cd-invoice-container-template-3 .cd-item-details .cd-list-table tbody tr td' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' 		=> 'cd_invoice_table_body_odd_bg',
				'types' 	=> [ 'classic', 'gradient' ],
				'selector' 	=> '{{WRAPPER}} .cd-invoice-container-template-2 .cd-item-details .cd-list-table tbody tr ,
								{{WRAPPER}} .cd-invoice-container-template-3 .cd-item-details .cd-list-table tbody tr',
				'condition' => [
					'cd_invoice_template' => ['template-2', 'template-3'],
				],
			]
		);

        $this->end_controls_tab();

        $this->end_controls_tabs();

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' 		=> 'cd_invoice_table_border',
				'selector' 	=> '{{WRAPPER}} .cd-invoice-container-template-1 .cd-item-details .cd-list-table th, 
								{{WRAPPER}} .cd-invoice-container-template-1 .cd-item-details .cd-list-table td',
				'condition' => [
					'cd_invoice_template' => 'template-1',
				],
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'cd_invoice_order_table_style_section',
			[
                'label'      => __( 'Order Details', 'codesigner-pro' ),
				'tab'        => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs(
            'cd_invoice_order_table_style_tabs'
        );

        $this->start_controls_tab(
            'cd_invoice_order_info_table_style_tab',
            [
                'label'     => esc_html__( 'Order Info', 'codesigner-pro' ),
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'      => 'cd_invoice_order_info_table_typography',
				'selector'  => '{{WRAPPER}} .cd-invoice-container-template-1 .cd-totals .cd-order-info td ,
								{{WRAPPER}} .cd-invoice-container-template-2 .cd-totals .cd-order-info td ,
								{{WRAPPER}} .cd-invoice-container-template-3 .cd-totals .cd-order-info td',
			]
		);

        $this->add_control(
			'cd_invoice_order_info_table_color',
			[
				'label'     => esc_html__( 'Text Color', 'codesigner-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .cd-invoice-container-template-1 .cd-totals .cd-order-info .label' => 'color: {{VALUE}}',
					'{{WRAPPER}} .cd-invoice-container-template-1 .cd-totals .cd-order-info .value' => 'color: {{VALUE}}',
					'{{WRAPPER}} .cd-invoice-container-template-2 .cd-totals .cd-order-info .label' => 'color: {{VALUE}}',
					'{{WRAPPER}} .cd-invoice-container-template-2 .cd-totals .cd-order-info .value' => 'color: {{VALUE}}',
					'{{WRAPPER}} .cd-invoice-container-template-3 .cd-totals .cd-order-info .label' => 'color: {{VALUE}}',
					'{{WRAPPER}} .cd-invoice-container-template-3 .cd-totals .cd-order-info .value' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' 		=> 'cd_invoice_order_info_table_border',
				'selector' 	=> '{{WRAPPER}} .cd-invoice-container-template-1 .cd-totals table .cd-order-info td',
				'condition' => [
					'cd_invoice_template' => 'template-1',
				],
			]
		);

        $this->end_controls_tab();

        $this->start_controls_tab(
            'cd_invoice_order_total_table_style_tab',
            [
                'label'     => esc_html__( 'Order Total', 'codesigner-pro' ),
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'      => 'cd_invoice_order_total_table_typography',
				'selector'  => '{{WRAPPER}} .cd-invoice-container-template-1 .cd-totals .cd-order-total td ,
								{{WRAPPER}} .cd-invoice-container-template-2 .cd-totals .cd-order-total td ,
								{{WRAPPER}} .cd-invoice-container-template-3 .cd-totals .cd-order-total td',
			]
		);

        $this->add_control(
			'cd_invoice_order_total_table_color',
			[
				'label'     => esc_html__( 'Text Color', 'codesigner-pro' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#fff',
				'selectors' => [
					'{{WRAPPER}} .cd-invoice-container-template-1 .cd-totals .cd-order-total td' 		=> 'color: {{VALUE}}',
					'{{WRAPPER}} .cd-invoice-container-template-2 .cd-totals .cd-order-total td' 		=> 'color: {{VALUE}}',
					'{{WRAPPER}} .cd-invoice-container-template-3 .cd-totals .cd-order-total td.value' 	=> 'color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'cd_invoice_order_total_table_temp_one_bg',
			[
				'label'     => esc_html__( 'Background Color', 'codesigner-pro' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#242424',
				'selectors' => [
					'{{WRAPPER}} .cd-invoice-container-template-1 .cd-totals .cd-order-total td' => 'background: {{VALUE}}',
				],
				'condition' => [
					'cd_invoice_template' => 'template-1',
				],
			]
		);

        $this->add_control(
			'cd_invoice_order_total_table_temp_two_bg',
			[
				'label'     => esc_html__( 'Background Color', 'codesigner-pro' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#ff8d39',
				'selectors' => [
					'{{WRAPPER}} .cd-invoice-container-template-2 .cd-totals .cd-order-total td' => 'background: {{VALUE}}',
				],
				'condition' => [
					'cd_invoice_template' => 'template-2',
				],
			]
		);

        $this->add_control(
			'cd_invoice_order_total_table_temp_three_bg',
			[
				'label'     => esc_html__( 'Background Color', 'codesigner-pro' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#002434',
				'selectors' => [
					'{{WRAPPER}} .cd-invoice-container-template-3 .cd-totals .cd-order-total td.value' 	=> 'background: {{VALUE}}',
				],
				'condition' => [
					'cd_invoice_template' => 'template-3',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' 		=> 'cd_invoice_order_total_table_border',
				'selector' 	=> '{{WRAPPER}} .cd-invoice-container-template-1 .cd-totals table .cd-order-total td',
				'condition' => [
					'cd_invoice_template' => 'template-1',
				],
			]
		);

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        $this->start_controls_section(
            'cd_invoice_billing_style_section',
			[
                'label'      => __( 'Billing', 'codesigner-pro' ),
				'tab'        => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs(
            'cd_invoice_billing_style_tabs'
        );

        $this->start_controls_tab(
            'cd_invoice_billing_title_style_tab',
            [
                'label'     => esc_html__( 'Title', 'codesigner-pro' ),
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'      => 'cd_invoice_billing_title_typography',
				'selector'  => '{{WRAPPER}} .cd-invoice-container-template-1 .cd-additional-info .cd-billing th ,
								{{WRAPPER}} .cd-invoice-container-template-2 .cd-additional-info .cd-billing th ,
								{{WRAPPER}} .cd-invoice-container-template-3 .cd-additional-info .cd-billing th',
			]
		);

        $this->add_control(
			'cd_invoice_billing_title_color',
			[
				'label'     => esc_html__( 'Text Color', 'codesigner-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .cd-invoice-container-template-1 .cd-additional-info .cd-billing th' => 'color: {{VALUE}}',
					'{{WRAPPER}} .cd-invoice-container-template-2 .cd-additional-info .cd-billing th' => 'color: {{VALUE}}',
					'{{WRAPPER}} .cd-invoice-container-template-3 .cd-additional-info .cd-billing th' => 'color: {{VALUE}}',
				],
			]
		);

        $this->end_controls_tab();

        $this->start_controls_tab(
            'cd_invoice_billing_name_style_tab',
            [
                'label'     => esc_html__( 'Name', 'codesigner-pro' ),
				'condition' => [
					'cd_invoice_template' => ['template-2', 'template-3'],
				],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'      => 'cd_invoice_billing_name_typography',
				'selector'  => '{{WRAPPER}} .cd-invoice-container-template-2 .cd-additional-info .cd-billing th .cd-customer-name tr td ,
								{{WRAPPER}} .cd-invoice-container-template-3 .cd-additional-info .cd-billing th .cd-customer-name tr td',
			]
		);

        $this->add_control(
			'cd_invoice_billing_name_color',
			[
				'label'     => esc_html__( 'Text Color', 'codesigner-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .cd-invoice-container-template-2 .cd-additional-info .cd-billing th .cd-customer-name tr td' => 'color: {{VALUE}}',
					'{{WRAPPER}} .cd-invoice-container-template-3 .cd-additional-info .cd-billing th .cd-customer-name tr td' => 'color: {{VALUE}}',
				],
			]
		);

        $this->end_controls_tab();

        $this->start_controls_tab(
            'cd_invoice_billing_address_style_tab',
            [
                'label'     => esc_html__( 'Address', 'codesigner-pro' ),
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'      => 'cd_invoice_billing_address_typography',
				'selector'  => '{{WRAPPER}} .cd-invoice-container-template-1 .cd-additional-info .cd-billing td ,
								{{WRAPPER}} .cd-invoice-container-template-2 .cd-additional-info .cd-billing td ,
								{{WRAPPER}} .cd-invoice-container-template-3 .cd-additional-info .cd-billing td',
			]
		);

        $this->add_control(
			'cd_invoice_billing_address_color',
			[
				'label'     => esc_html__( 'Text Color', 'codesigner-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .cd-invoice-container-template-1 .cd-additional-info .cd-billing td' 					=> 'color: {{VALUE}}',
					'{{WRAPPER}} .cd-invoice-container-template-2 .cd-additional-info .cd-billing tr:nth-child(2) td' 	=> 'color: {{VALUE}}',
					'{{WRAPPER}} .cd-invoice-container-template-3 .cd-additional-info .cd-billing tr:nth-child(2) td' 	=> 'color: {{VALUE}}',
				],
			]
		);

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        $this->start_controls_section(
            'cd_invoice_shipping_style_section',
			[
                'label'      => __( 'Shipping', 'codesigner-pro' ),
				'tab'        => Controls_Manager::TAB_STYLE,
				'condition' => [
					'cd_invoice_template' => ['template-1', 'template-2'],
				],
            ]
        );

        $this->start_controls_tabs(
            'cd_invoice_shipping_style_tabs'
        );

        $this->start_controls_tab(
            'cd_invoice_shipping_title_style_tab',
            [
                'label'     => esc_html__( 'Title', 'codesigner-pro' ),
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'      => 'cd_invoice_shipping_title_typography',
				'selector'  => '{{WRAPPER}} .cd-invoice-container-template-1 .cd-additional-info .cd-shipping th ,
								{{WRAPPER}} .cd-invoice-container-template-2 .cd-additional-info .cd-shipping th',
			]
		);

        $this->add_control(
			'cd_invoice_shipping_title_color',
			[
				'label'     => esc_html__( 'Text Color', 'codesigner-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .cd-invoice-container-template-1 .cd-additional-info .cd-shipping th' => 'color: {{VALUE}}',
					'{{WRAPPER}} .cd-invoice-container-template-2 .cd-additional-info .cd-shipping th' => 'color: {{VALUE}}',
				],
			]
		);

        $this->end_controls_tab();

        $this->start_controls_tab(
            'cd_invoice_shipping_name_style_tab',
            [
                'label'     => esc_html__( 'Name', 'codesigner-pro' ),
				'condition' => [
					'cd_invoice_template' => 'template-2',
				],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'      => 'cd_invoice_shipping_name_typography',
				'selector'  => '{{WRAPPER}} .cd-invoice-container-template-2 .cd-additional-info .cd-shipping th .cd-customer-name tr td',
			]
		);

        $this->add_control(
			'cd_invoice_shipping_name_color',
			[
				'label'     => esc_html__( 'Text Color', 'codesigner-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .cd-invoice-container-template-2 .cd-additional-info .cd-shipping th .cd-customer-name tr td' => 'color: {{VALUE}}',
				],
			]
		);

        $this->end_controls_tab();

        $this->start_controls_tab(
            'cd_invoice_shipping_address_style_tab',
            [
                'label'     => esc_html__( 'Address', 'codesigner-pro' ),
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'      => 'cd_invoice_shipping_address_typography',
				'selector'  => '{{WRAPPER}} .cd-invoice-container-template-1 .cd-additional-info .cd-shipping td ,
								{{WRAPPER}} .cd-invoice-container-template-2 .cd-additional-info .cd-shipping td',
			]
		);

        $this->add_control(
			'cd_invoice_shipping_address_color',
			[
				'label'     => esc_html__( 'Text Color', 'codesigner-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .cd-invoice-container-template-1 .cd-additional-info .cd-shipping td' => 'color: {{VALUE}}',
					'{{WRAPPER}} .cd-invoice-container-template-2 .cd-additional-info .cd-shipping td' => 'color: {{VALUE}}',
				],
			]
		);

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

    }

    protected function render() {
        $settings           = $this->get_settings_for_display();
        $selected_template  = $settings['cd_invoice_template'];
		$order_id 			= wcd_is_edit_mode() || wcd_is_preview_mode() ? wcd_get_random_order_id() : wcd_get_current_order_id();

		/**
		 * if order id not found show notice and return
		 */
		if ( ! $order_id ) {
			echo wcd_notice( sprintf( '%1s', __( 'You have no Order in your site. Create a New Order to view the template.', 'codesigner-pro' ) ) );

			return;
		}

		$order 	= wc_get_order( $order_id );
		$args 	= array(
			'template-slug' => $selected_template,
			'settings' 		=> $settings,
			'order' 		=> $order,
		);

        echo codesigner_get_invoice_template( $args );
    }
}