<?php 
use Codexpert\CoDesigner_Pro\Helper;

$settings           = $args['settings'];
$order              = $args['order'];
$products           = $order->get_items();
$order_totals       = $order->get_order_item_totals();
$billing_address    = $order->get_formatted_billing_address();
$shipping_address   = $order->get_formatted_shipping_address();
$date               = \DateTime::createFromFormat( 'Y-m-d H:i:s', $order->order_date );
$order_date         = $date->format( 'F j, Y' );

// Helper::pri( $order );
?>

<div class="cd-invoice-container-template-2">
<table class="cd-invoice">
    <tr class="cd-header">
        <td class="cd-company-logo">
            <img src="<?php echo $settings['cd_template_logo']['url']; ?>" alt="<?php echo get_bloginfo('name'); ?>" />
        </td>
        <td class="cd-title">
            <?php echo sprintf( '%1s', __( $settings['cd_invoice_title'], 'codesigner-pro' ) ); ?>
        </td>
    </tr>
    <tr class="cd-intro">
        <td class="cd-msg">
            <?php if ( 'yes' === $settings['cd_show_thank_you'] ) : ?>
            <p class="cd-msg-block">
                <?php echo $settings['cd_thank_you_msg']; ?>
            </p>
            <?php endif; ?>
        </td>
        <td class="cd-order-info">
            <p class="cd-order-num"><?php echo sprintf( '%1s #%2s', __( 'Order No:', 'codesigner-pro' ), __( $order->get_id(), 'codesigner-pro' ) ); ?></p>
            <p class="cd-order-date"><?php echo sprintf( '%1s %2s', __( 'Date:', 'codesigner-pro' ), $order_date ); ?></p>
        </td>
    </tr>
    <tr class="cd-additional-info">
        <td>
            <?php if ( 'yes' === $settings['cd_show_billing'] ) : ?>
            <table class="cd-billing">
                <tr>
                    <th>
                        <p class="cd-billing-title"><?php echo $settings['cd_billing_title']; ?></p>
                        <table class="cd-customer-name">
                            <tr>
                                <td>
                                    <p><?php echo $order->billing_first_name . ' ' . $order->billing_last_name; ?></p>
                                </td>
                            </tr>
                        </table>
                    </th>
                </tr>
                <tr>
                    <td>
                        <p class="cd-billing-address">
                            <?php echo wp_kses_post( $billing_address ? $billing_address : esc_html__( 'N/A', 'codesigner-pro' ) ); ?>
                        </p>
                    </td>
                </tr>
            </table>
            <?php endif; ?>
        </td>
        <td>
            <?php if ( 'yes' === $settings['cd_show_shipping'] ) : ?>
            <table class="cd-shipping">
                <tr>
                    <th>
                        <p class="cd-shipping-title"><?php echo $settings['cd_shipping_title']; ?></p>
                        <table class="cd-customer-name">
                            <tr>
                                <td>
                                    <p><?php echo $order->shipping_first_name . ' ' . $order->shipping_last_name; ?></p>
                                </td>
                            </tr>
                        </table>
                    </th>
                </tr>
                <tr>
                    <td>
                        <p class="cd-shipping-address">
                            <?php echo wp_kses_post( $shipping_address ? $shipping_address : esc_html__( 'N/A', 'codesigner-pro' ) ); ?>
                        </p>
                    </td>
                </tr>
            </table>
            <?php endif; ?>
        </td>
    </tr>
    <tr class="cd-item-details">
        <td colspan="2">
            <table class="cd-list-table">
                <thead>
                    <tr>
                        <th class="left"><?php echo esc_html__( 'Product', 'codesigner-pro' ); ?></th>
                        <th class="center"><?php echo esc_html__( 'Quantity', 'codesigner-pro' ); ?></th>
                        <th class="right"><?php echo esc_html__( 'Price', 'codesigner-pro' ); ?></th>
                    </tr>
                </thead>
                <tbody>
                <?php
                foreach( $products as $id=>$product ) {
                    $product_name   = $product->get_name();
                    $quantity       = $product->get_quantity();
                    $subtotal       = $product->get_subtotal();

                    echo sprintf( 
                        '<tr class="cd-item">
                            <td class="left">%1s</td>
                            <td class="center">%2s</td>
                            <td class="right">%3s</td>
                        </tr>', $product_name, $quantity, wc_price( $subtotal ) );
                }
                ?>
                </tbody>
            </table>
        </td> 
    </tr>
    <tr class="cd-totals">
        <td></td>
        <td>
            <table>
            <?php 
            foreach( $order_totals as $key=>$total ) {
                $class_name = $key !== 'order_total' ? 'cd-order-info' : 'cd-order-total';

                echo sprintf(
                    '<tr class="%1s">
                        <td class="label">%2s</td>
                        <td class="value">%3s</td>
                    </tr>',
                    $class_name,
                    $total['label'],
                    $total['value'],
                );
            }
            ?>
            </table>
        </td>
    </tr>
</table>
</div>
