<?php
use Codexpert\CoDesigner_Pro\Helper;

/**
 * Load the selected email template
 * 
 * @param array $args
 */
if( ! function_exists( 'codesigner_load_email_template' ) ) :
    function codesigner_load_email_template( $args ) {
        // default template directory
        $template_dir   = dirname( CODESIGNER_PRO ) . '/modules/email-templates/templates/' . $args['template-slug'] . '/';

        // full path of a template file in module directory
        $template_path  = $template_dir . $args['template-slug'] . '.php';

        if ( file_exists( $template_path ) ) {
            ob_start();
            include $template_path;
            return ob_get_clean();
        }
        else {
            echo wcd_notice( sprintf( '%1s', __( 'Template not Found.', 'codesigner-pro' ) ) );

            return;
        }
    }
endif;

/**
 * Get new email designer controls filename list
 * 
 * @return array $email_controls_filename_list
 */
if( ! function_exists( 'codesigner_get_email_controls_list' ) ) :
    function codesigner_get_email_controls_list() {
        $email_controls = [
            'admin-new-order', 
            'admin-cancelled-order', 
            'admin-failed-order', 
            'customer-on-hold-order', 
            'customer-processing-order', 
            'customer-completed-order', 
            'customer-refunded-order', 
            'customer-invoice', 
            'customer-note', 
            'customer-reset-password', 
            'customer-new-account', 
        ];

        return $email_controls;
    }
endif;

/**
 * Load specific controls for email templates
 * 
 * @param array $args
 * 
 * @return void
 */
if( ! function_exists( 'codesigner_load_email_template_controls' ) ) :
    function codesigner_load_email_template_controls( $args ) {
        // default template controls directory
        $controls_dir   = dirname( CODESIGNER_PRO ) . "/modules/email-templates/controls/";

        // full path of a template file in module directory
        $controls_path  = $controls_dir . $args['control-slug'] . '.php';

        if ( file_exists( $controls_path ) ) {
            ob_start();
            include $controls_path;
            return ob_get_clean();
        }
    }
endif;

/**
 * Get the name of css file associated with email template
 * 
 * @param string|number $template_id
 * 
 * @return string $css_filename
 */
if( ! function_exists( 'codesigner_get_css_filename' ) ) :
    function codesigner_get_css_filename( $template_id ) {
        $data           = get_post_meta( $template_id, '_elementor_data', true );
        $css_filename   = json_decode( $data )[0]->elements[0]->settings->cd_email_type;

        return $css_filename;
    }
endif;

/**
 * Get css file content
 * 
 * @param string|number $template_id
 * 
 * @return string $css
 */
if( ! function_exists( 'codesigner_get_css_file_content' ) ) :
    function codesigner_get_css_file_content( $template_id ) {
        $css = file_get_contents( dirname( CODESIGNER_PRO ) . '/modules/email-templates/assets/css/' . codesigner_get_css_filename( $template_id ) . '.css' );
        return $css;
    }
endif;

/**
 * Get css file content
 * 
 * @param string|number $template_id
 * 
 * @return string $css
 */
if( ! function_exists( 'codesigner_get_common_css' ) ) :
    function codesigner_get_common_css() {
        $css = file_get_contents( dirname( CODESIGNER_PRO ) . '/modules/email-templates/assets/css/common.css' );

        return $css;
    }
endif;

/**
 * Return list of woocommerce order edit page hooks
 *
 * @since 3.0
 * @author al imran akash <alimranakash@gmail.com>
 */
if( !function_exists( 'wcd_get_template_css' ) ) :
    function wcd_get_template_css( $template_id ) {
        $css_files   = [];
        $css_files[] = trailingslashit( ELEMENTOR_ASSETS_URL ) . 'css/frontend.min.css';
        $css_files[] = trailingslashit( ELEMENTOR_ASSETS_URL ) . 'css/common.min.css';
        $css_files[] = trailingslashit( ELEMENTOR_ASSETS_URL ) . 'lib/font-awesome/css/font-awesome.min.css';
        $css_files[] = trailingslashit( ELEMENTOR_ASSETS_URL ) . 'lib/eicons/css/elementor-icons.min.css';
        $css_files[] = trailingslashit( ELEMENTOR_ASSETS_URL ) . 'lib/font-awesome/css/solid.min.css';
        $css_files[] = trailingslashit( ELEMENTOR_ASSETS_URL ) . 'lib/font-awesome/css/brands.min.css';
        $css_files[] = trailingslashit( CODESIGNER_ASSETS ) . 'css/front.css';
        $css_files[] = trailingslashit( CODESIGNER_ASSETS ) . 'css/cx-grid.css';

        global $wp_styles;
        foreach( $wp_styles->queue as $_style ) :
            $css_files[] = $wp_styles->registered[ $_style ]->src;
        endforeach;

        $css = '';
        foreach ( $css_files as $css_file ) {
            if( strpos( $css_file, 'admin-bar.min.css' ) == false ) {
                $css .= file_get_contents( $css_file );
            }
        }

        if( codesigner_new_email_designer_active() ) {
            $default_css    = codesigner_get_css_file_content( $template_id );
            $common_css     = codesigner_get_common_css();
            $css            .= $default_css;
            $css            .= $common_css;
        }
        else{
            $css        .= ".elementor-widget-container{width:100%;}table {border-spacing: 0;border-collapse: collapse;width:100%}table td{width:200px;padding:10px; border: 1px solid #000}";
            $upload_dir = wp_get_upload_dir();
            $post_css   = file_get_contents( "{$upload_dir['basedir']}/elementor/css/post-{$template_id}.css" );
            $post_css   = preg_replace( '/@media\(min-width:\d+px\)\{/', '', $post_css );
            $post_css   = str_replace( '}}', '}', $post_css );
            $css        .= $post_css;
        }

        if( ! codesigner_new_email_designer_active() ) {
            // add float left
            $css        = str_replace( 'display:flex', '', $css );
            $css        = str_replace( 'width', '', $css );
            $css        = str_replace( '--container-widget-width', '', $css );
            $pattern    = '/width\s*:\s*(\d+(\.\d+)?)%/i';

            $replacement = function( $matches ) {
                $widthValue = $matches[1]; 
                return "float:left;width:$widthValue%!important;";
            };
            $css        = preg_replace_callback( $pattern, $replacement, $css );
        }

        return $css;
    }
endif;

/**
 * Check If new Email Designer Active or not
 * 
 * @return boolean $is_active
 */
if( ! function_exists( 'codesigner_new_email_designer_active' ) ) :
    function codesigner_new_email_designer_active() {
        $is_active = Helper::get_option( 'codesigner_email_designer', 'enable-email-designer-template', false );

        return $is_active;
    }
endif;