<?php
use Codexpert\CoDesigner_Pro\Helper;

$settings               = $args[ 'settings' ];
$billing_address_txt    = $settings[ 'billing_address_txt_temp6' ];
$shipping_address_txt   = $settings[ 'shipping_address_txt_temp6' ];
$order_txt              = $settings[ 'order_txt_temp6' ];
$payment_txt            = $settings[ 'payment_txt_temp6' ];
$order_btn              = $settings[ 'order_btn_txt_temp6' ];
$ship_to                = $settings[ 'ship_to_different_temp6' ];
$order_notes            = $settings[ 'temp-6-order-notes' ];
$cart                   = WC()->cart;
$cart_items             = $cart->get_cart();

if ( class_exists('WooCommerce') ) {
    $checkout        = WC()->checkout;
}

?>
<!--== Coupon Form Section Starts Here ==-->
<div id="temp6-cd-coupon">
    <div class="woocommerce-form-coupon-toggle" id="cd-coupon-form">
        <?php wc_print_notice( apply_filters( 'woocommerce_checkout_coupon_message', esc_html__( 'Have a coupon?', 'woocommerce' ) . ' <a href="#" class="showcoupon">' . esc_html__( 'Enter Coupon' , 'woocommerce' ) . '</a>' ), 'notice' ); ?>
    </div>

    <form id="cd-coupon-main" class="checkout_coupon woocommerce-form-coupon" method="post" style="display:none">
        <p><?php esc_html_e( 'If you have a coupon code, apply it below.' , 'woocommerce' ); ?></p>

        <div class="cd-coupon-from-row">
            <p class="form-row form-row-first">
                <label for="coupon_code" class="screen-reader-text"><?php esc_html_e( 'Coupon:', 'woocommerce' ); ?></label>
                <input type="text" name="coupon_code" class="input-text" placeholder="<?php esc_attr_e( 'Coupon code', 'woocommerce' ); ?>" id="coupon_code" value="" />
            </p>
            <p class="form-row form-row-last">
                <button type="submit" class="button<?php echo esc_attr( 'button' ); ?>" name="apply_coupon" value="<?php esc_attr_e( 'Apply Coupon', 'woocommerce' ); ?>"><?php esc_html_e( 'Apply coupon', 'woocommerce' ); ?></button>
            </p>
        </div>
    </form>
</div>

<!--== Coupon Form Section Ends Here ==-->
<form name="checkout" method="post" class="checkout woocommerc.e-checkout" action="<?php echo esc_url( wc_get_checkout_url() ); ?>" enctype="multipart/form-data">
    <div class="cd-checkout-temp-6">
        <?php if ( ! is_user_logged_in() ) : ?>
            <p id="cd-temp-6-login">
                <?php echo esc_html__( 'Have an account? ', 'codesigner-pro' ); ?>
                <a href="<?php echo wp_login_url(); ?>"><?php echo esc_html__( 'Log In', 'codesigner-pro' ); ?></a>
            </p>
        <?php endif ?>

        <div class="cd-temp-6-grid">
            <div class="cd-address-container">
                <div id="cd-billing">
                    <h3 class="title">
                        <?php echo esc_html__( $billing_address_txt, 'codesigner-pro' ); ?>
                    </h3>
                
                    <?php do_action( 'woocommerce_before_checkout_billing_form', $checkout ); ?>
                    <div id="cd-billing-fields">
                        <?php
                            $fields = $checkout->get_checkout_fields( 'billing' );

                            foreach ( $fields as $key => $field ) {
                                woocommerce_form_field( $key, $field, $checkout->get_value( $key ) );
                            }
                        ?>
                    </div>
                    <?php do_action( 'woocommerce_after_checkout_billing_form', $checkout ); ?>
                </div>

                <div class="cd-enable-shipping">
                    <input id="cd-ship-different" type="checkbox">
                    <label for="cd-ship-different">
                        <?php echo esc_html__( $ship_to , 'woocommerce' ); ?>
                    </label>
                </div>

                <div id="cd-shipping" style="display: none;">
                    <h3 class="title">
                        <?php echo esc_html__( $shipping_address_txt , 'codesigner-pro' ); ?>
                    </h3>

                    <?php do_action( 'woocommerce_before_checkout_shipping_form', $checkout ); ?>
                    <div id="cd-shipping-fields">
                        <?php
                            $fields = $checkout->get_checkout_fields( 'shipping' );

                            foreach ( $fields as $key => $field ) {
                                woocommerce_form_field( $key, $field, $checkout->get_value( $key ) );
                            }
                        ?>
                    </div>
                    <?php do_action( 'woocommerce_after_checkout_shipping_form', $checkout ); ?>
                </div>

                <div id="cd-order-notes">
                    <p class="form-row notes" id="order_comments_field">
                        <label for="order_comments"><?php _e( $order_notes, 'woocommerce' ); ?></label>
                        <textarea name="order_comments" class="input-text" id="order_comments" placeholder="<?php esc_attr_e( 'Notes about your order, e.g. special notes for delivery.', 'woocommerce' ); ?>"></textarea>
                    </p>
                </div>

            </div>

            <div id="cd-order-summery">
                <h2 class="title cd-temp-6-order-title">
                    <?php echo esc_html__( $order_txt, 'codesigner-pro' ); ?>
                </h2>

                <div id="cd-product-list">
                    <?php
                    do_action( 'woocommerce_review_order_before_cart_contents' );

                    foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
                        $_product   = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
                        $image      = $_product->get_image();

                        if ( $_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters( 'woocommerce_checkout_cart_item_visible', true, $cart_item, $cart_item_key ) ) {
                            ?>
                            <div class="cd-temp-6-cart-product <?php echo esc_attr( apply_filters( 'woocommerce_cart_item_class', 'cart_item', $cart_item, $cart_item_key ) ); ?>">
                                <div class="cd-product-image">
                                    <?php echo $image; ?>
                                </div>

                                <div class="cd-product-details">
                                    <a href="<?php echo $_product->get_permalink( $cart_item );?>"><?php echo esc_html( $_product->get_name() );?></a>
                                    <p class="cd-temp-6-variation">
                                        <?php echo wc_get_formatted_cart_item_data( $cart_item ); ?>
                                    </p>
                                    <p class="cd-product-qty">Qty: <?php echo $cart_item['quantity']; ?></p>
                                </div>

                                <p class="cd-product-price">
                                <?php echo apply_filters( 'woocommerce_cart_item_subtotal', WC()->cart->get_product_subtotal( $_product, $cart_item['quantity'] ), $cart_item, $cart_item_key ) ;?>
                                </p>
                            </div>
                            <?php
                        }
                    }

                    do_action( 'woocommerce_review_order_after_cart_contents' );
                    ?>
                </div>

                <div id="cd-checkout-tfoot-wrap">
                    <table class="woocommerce-checkout-review-order-table">
                        <tfoot id="cd-checkout-tfoot">
                            <tr class="cart-subtotal">
                                <th><?php esc_html_e( 'Subtotal', 'wocommerce' ); ?></th>
                                <td><?php wc_cart_totals_subtotal_html(); ?></td>
                            </tr>
                            <?php foreach ( WC()->cart->get_coupons() as $code => $coupon ) : ?>
                                <tr class="cart-discount coupon-<?php echo esc_attr( sanitize_title( $code ) ); ?>">
                                    <th><?php wc_cart_totals_coupon_label( $coupon ); ?></th>
                                    <td><?php wc_cart_totals_coupon_html( $coupon ); ?></td>
                                </tr>
                            <?php endforeach; ?>
    
                            <?php if ( WC()->cart->needs_shipping() && WC()->cart->show_shipping() ) : ?>
                                <?php do_action( 'woocommerce_review_order_before_shipping' ); ?>
                                <?php WC()->cart->calculate_totals(); ?>
                                <?php wc_cart_totals_shipping_html(); ?>
                                <?php do_action( 'woocommerce_review_order_after_shipping' ); ?>
                            <?php endif; ?>
    
                            <?php foreach ( WC()->cart->get_fees() as $fee ) : ?>
                                <tr class="fee">
                                    <th><?php echo esc_html( $fee->name ); ?></th>
                                    <td><?php wc_cart_totals_fee_html( $fee ); ?></td>
                                </tr>
                            <?php endforeach; ?>
    
                            <?php if ( wc_tax_enabled() && ! WC()->cart->display_prices_including_tax() ) : ?>
                                <?php if ( 'itemized' === get_option( 'woocommerce_tax_total_display' ) ) : ?>
                                    <?php foreach ( WC()->cart->get_tax_totals() as $code => $tax ) : ?>
                                        <tr class="tax-rate tax-rate-<?php echo esc_attr( sanitize_title( $code ) ); ?>">
                                            <th><?php echo esc_html( $tax->label ); ?></th>
                                            <td><?php echo wp_kses_post( $tax->formatted_amount ); ?></td>
                                        </tr>
                                    <?php endforeach; ?>
                                <?php else : ?>
                                    <tr class="tax-total">
                                        <th><?php echo esc_html( WC()->countries->tax_or_vat() ); ?></th>
                                        <td><?php wc_cart_totals_taxes_total_html(); ?></td>
                                    </tr>
                                <?php endif; ?>
                            <?php endif; ?>

                            <?php do_action( 'woocommerce_review_order_before_order_total' ); ?>
                            <tr class="order-total">
                                <th><?php esc_html_e( 'Total' , 'woocommerce' ); ?></th>
                                <td><?php wc_cart_totals_order_total_html(); ?></td>
                            </tr>
                            <?php do_action( 'woocommerce_review_order_after_order_total' ); ?>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>

        <div class="cd-temp-6-grid">
            <div class="cd-address-container">
                <div id="cd-temp-6-payment">
                    <h2 class="title"><?php echo esc_html__( $payment_txt , 'codesigner-pro' ); ?></h2>               
                    <?php
                        if ( ! wp_doing_ajax() ) {
                            do_action( 'woocommerce_review_order_before_payment' );
                        }
                    ?>
                    <div id="payment" class="woocommerce-checkout-payment-t">
                        <?php if ( WC()->cart->needs_payment() ) : ?>
                            <ul class="wc_payment_methods payment_methods methods">
                                <?php
                                $available_gateways = WC()->payment_gateways->get_available_payment_gateways();
                                if ( ! empty( $available_gateways ) ) {
                                    $i = 1;
                                    foreach ( $available_gateways as $gateway ) {
                                        ?>
                                        <li class="<?php echo $i === 1 || checked( $gateway->chosen, true ) ? 'cd-select' : ''; ?> wc_payment_method payment_method_<?php echo esc_attr( $gateway->id ); ?>">
                                            <input id="payment_method_<?php echo esc_attr( $gateway->id ); ?>" type="radio" class="input-radio" name="payment_method" value="<?php echo esc_attr( $gateway->id ); ?>" <?php checked( $gateway->chosen, true ); ?> data-order_button_text="<?php echo esc_attr( $gateway->order_button_text ); ?>" />
        
                                            <label for="payment_method_<?php echo esc_attr( $gateway->id ); ?>">
                                                <?php echo $gateway->get_title(); ?> <?php echo $gateway->get_icon(); ?>
                                            </label>
                                            <?php if ( $gateway->has_fields() || $gateway->get_description() ) : ?>
                                                <div id="cd-payment-description" class="payment_box payment_method_<?php echo esc_attr( $gateway->id ); ?>">
                                                    <?php $gateway->payment_fields(); ?>
                                                </div>
                                            <?php endif; ?>
                                        </li>
                                        <?php
                                        $i++;
                                    }
                                } else {
                                    echo '<li>';
                                    wc_print_notice( apply_filters( 'woocommerce_no_available_payment_methods_message', WC()->customer->get_billing_country() ? esc_html__( 'Sorry, it seems that there are no available payment methods. Please contact us if you require assistance or wish to make alternate arrangements.', 'woocommerce' ) : esc_html__( 'Please fill in your details above to see available payment methods.', 'woocommerce' ) ), 'notice' );
                                    echo '</li>';
                                }
                                ?>
                            </ul>
                        <?php endif; ?>
                    </div>
                </div>
        
                <div id="cd-temp-6-place-order">
                    <?php 
                        wc_get_template( 'checkout/terms.php' );
                    ?>
                    <div class="form-row place-order">
                        <?php do_action( 'woocommerce_review_order_before_submit' ); ?>
                        <?php $order_button_text = apply_filters( 'woocommerce_pay_order_button_text', __( $order_btn, 'woocommerce' ) ); ?>
                        <?php echo apply_filters( 'woocommerce_order_button_html', '<button type="submit" class="button alt' . esc_attr( 'button' ) . ' name="woocommerce_checkout_place_order" id="place_order" value="' . esc_attr( $order_button_text ) . '" data-value="' . esc_attr( $order_button_text ) . '">' . esc_html( $order_button_text ) . '</button>' ); ?>
                        <?php do_action( 'woocommerce_review_order_after_submit' ); ?>
                        <?php wp_nonce_field( 'woocommerce-process_checkout', 'woocommerce-process-checkout-nonce' ); ?>
                    </div>
                    <?php
                        if ( ! wp_doing_ajax() ) {
                            do_action( 'woocommerce_review_order_after_payment' );
                        }
                    ?> 
                </div>
            </div>
            <div></div>
        </div>
    </div>
</form>