<?php 
use Codexpert\CoDesigner_Pro\Helper;

$checkout   			= WC()->checkout;
$fields  				= $checkout->get_checkout_fields('billing');
$settings 				= $args['settings'];
?>
<!-- Coupon Code  -->
<div id="temp3-cd-coupon">
	<div class="woocommerce-form-coupon-toggle" id="cd-coupon-form">
		<?php wc_print_notice( apply_filters( 'woocommerce_checkout_coupon_message', esc_html__( 'Have a coupon?', 'woocommerce' ) . ' <a href="#" class="showcoupon">' . esc_html__( 'Enter Coupon', 'woocommerce' ) . '</a>' ), 'notice' ); ?>
	</div>
	<form class="checkout_coupon woocommerce-form-coupon" method="post" style="display:none">
		<p><?php esc_html_e( 'If you have a coupon code, please apply it below.', 'woocommerce' ); ?></p>

		<div class="cd-coupon-from-row">
			<p class="form-row form-row-first">
				<label for="coupon_code" class="screen-reader-text"><?php esc_html_e( 'Coupon:', 'woocommerce' ); ?></label>
				<input type="text" name="coupon_code" class="input-text" placeholder="<?php esc_attr_e( 'Coupon code', 'woocommerce' ); ?>" id="coupon_code" value="" />
			</p>
			
			<p class="form-row form-row-last">
				<button type="submit" class="button<?php echo esc_attr( 'button' ) ; ?>" name="apply_coupon" value="<?php esc_attr_e( 'Apply coupon', 'woocommerce' ); ?>"><?php esc_html_e( 'Apply coupon', 'woocommerce' ); ?></button>
			</p>
		</div>

		<div class="clear"></div>
	</form>
</div>

<!-- Main Checkout form  -->
<form name="checkout" method="post" class="checkout temp-3 woocommerc.e-checkout" action="<?php echo esc_url( wc_get_checkout_url() ); ?>" enctype="multipart/form-data">
	<div class="codesigner-checkout-page-wraper">
		<!-- Left area  -->
		<div class="codesigner-left-area">
			<div class="billing-address-wrap">
				<h3><?php _e( $settings['temp-3-billing-heading'], 'codesigner-pro' );?></h3>
				<?php do_action( 'woocommerce_before_checkout_billing_form', $checkout ); ?>
				<div class="woocommerce-billing-fields__field-wrapper">
					<?php
						$fields = $checkout->get_checkout_fields( 'billing' );

						foreach ( $fields as $key => $field ) {
							woocommerce_form_field( $key, $field, $checkout->get_value( $key ) );
						}
					?>
				</div>
				<?php do_action( 'woocommerce_after_checkout_billing_form', $checkout ); ?>
			</div>
			<h3 id="ship-to-different-address">
				<label class="woocommerce-form__label woocommerce-form__label-for-checkbox checkbox">
					<input id="ship-to-different-address-checkbox" class="woocommerce-form__input woocommerce-form__input-checkbox input-checkbox" <?php checked( apply_filters( 'woocommerce_ship_to_different_address_checked', 'shipping' === get_option( 'woocommerce_ship_to_destination' ) ? 1 : 0 ), 1 ); ?> type="checkbox" name="ship_to_different_address" value="1" /> <span><?php esc_html_e( $settings['temp-3-ship-to-text'], 'woocommerce' ); ?></span>
				</label>
			</h3>
			<div class="shipping-address-wrap">
				<?php do_action( 'woocommerce_before_checkout_shipping_form', $checkout ); ?>
				<div class="woocommerce-shipping-fields__field-wrapper" id="shipping-address-wrap">
					<h3><?php echo esc_html__( $settings['temp-3-shipping-heading'] , 'codesigner-pro' ); ?></h3>
					<?php do_action( 'woocommerce_before_checkout_shipping_form', $checkout ); ?>
					<?php
					$fields = $checkout->get_checkout_fields( 'shipping' );

					foreach ( $fields as $key => $field ) {
						woocommerce_form_field( $key, $field, $checkout->get_value( $key ) );
					}
					?>
				</div>
				<?php do_action( 'woocommerce_after_checkout_shipping_form', $checkout ); ?>
			</div>
			<div class="order-notes codesinger-order-note">
				<p class="form-row notes" id="order_comments_field">
					<label for="order_comments"><?php _e( $settings['temp-3-order-notes'], 'woocommerce' ); ?></label>
					<textarea name="order_comments" class="input-text codesigner-order-textarea" id="order_comments" placeholder="<?php esc_attr_e( 'Notes about your order, e.g. special notes for delivery.', 'woocommerce' ); ?>"></textarea>
				</p>
        	</div>
		</div>
		<!-- Right area -->
		<div class="codesigner-right-area">	
			<div class="codesiner-billing-summary-wrap">
				<div class="codesinger-cart-item-wrap ">
					<h3><?php _e( $settings['temp-3-billing-summary-heading'], 'codesigner-pro' ); ?></h3>
						<?php
							do_action( 'woocommerce_review_order_before_cart_contents' );

							foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {

								$_product 			= apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
								$product_id 		= $cart_item['product_id'];
								$thumbnail_id 		= get_post_thumbnail_id( $product_id );
								$product_thumbnail 	= wp_get_attachment_image( $thumbnail_id, 'thumbnail' );
								?>
								<div class="codesigner-single-cart-item cd-product-id-<?php echo $product_id ?> ">
									<div class="codesigner-cart-item-left">
										<?php 
											if ( $_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters( 'woocommerce_checkout_cart_item_visible', true, $cart_item, $cart_item_key ) ) {
												
												?>
													<div class="codesigner-cart-item-thumbnail">
														<?php echo $product_thumbnail; ?>
														<td class="product-remove">
															<?php
																echo apply_filters( // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
																	'woocommerce_cart_item_remove_link',
																	sprintf(
																		'<a href="%s" class="remove" aria-label="%s" data-product_id="%s" data-product_sku="%s">&times;</a>',
																		esc_url( wc_get_cart_remove_url( $cart_item_key ) ),
																		/* translators: %s is the product name */
																		esc_attr( sprintf( __( 'Remove %s from cart', 'woocommerce' ), wp_strip_all_tags( $product_name ?? '' ) ) ),
																		esc_attr( $product_id ),
																		esc_attr( $_product->get_sku() )
																	),
																	$cart_item_key
																);
															?>
														</td>
													</div>
													<div class="codesigner-title-and-quantity-area">
														<p class="codesigner-product-title"><b><?php echo wp_kses_post( apply_filters( 'woocommerce_cart_item_name', $_product->get_name(), $cart_item, $cart_item_key ) ) . '&nbsp;'; ?> </b></p>

														<div class="codesinger-cart-quantity">
															<div class="cd-checkout-minus">
																<span class="dashicons dashicons-minus cd-cart-quatity" data-attr="remove" product-id="<?php echo $product_id ?>"></span>
															</div>
															<?php 
																$quantity = $cart_item['quantity'];	
																printf( '<input class="cd-cart-item-quantity cd-set-quantity-%s" value="%s" product-id="%1$s" type="number" >', $product_id, $quantity );
															?>
															<div class="cd-checkout-plus">
																<span class="dashicons dashicons-plus-alt2 cd-cart-quatity" data-attr= "add" product-id="<?php echo $product_id ?>" > </span>
															</div>
														</div>
														
													</div>
													<div class="codesinger-cart-item-price">
														<?php 
															echo wc_price( $_product->get_price() );
														?>
													</div>
												<?php
											}
										?>
									</div>
								</div>
									
								<?php
							}
						?>
					<?php do_action( 'woocommerce_review_order_after_cart_contents' ); ?>
					
					<table class="codesigner-price-table shop_table woocommerce-checkout-review-order-table">
						<tfoot>
							<tr class="cart-subtotal">
								<th><?php esc_html_e( 'Subtotal', 'woocommerce' ); ?></th>
								<td><?php wc_cart_totals_subtotal_html(); ?></td>
							</tr>

							<?php foreach ( WC()->cart->get_coupons() as $code => $coupon ) : ?>
								<tr class="cart-discount coupon-<?php echo esc_attr( sanitize_title( $code ) ); ?>">
									<th><?php wc_cart_totals_coupon_label( $coupon ); ?></th>
									<td><?php wc_cart_totals_coupon_html( $coupon ); ?></td>
								</tr>
							<?php endforeach; ?>

							<?php if ( WC()->cart->needs_shipping() && WC()->cart->show_shipping() ) : ?>
								<?php do_action( 'woocommerce_review_order_before_shipping' ); ?>
								<!-- Fourcefully calculate total  -->
								<?php WC()->cart->calculate_totals(); ?>
								<?php wc_cart_totals_shipping_html(); ?>
								<?php do_action( 'woocommerce_review_order_after_shipping' ); ?>
							<?php endif; ?>

							<?php foreach ( WC()->cart->get_fees() as $fee ) : ?>
								<tr class="fee">
									<th><?php echo esc_html( $fee->name ); ?></th>
									<td><?php wc_cart_totals_fee_html( $fee ); ?></td>
								</tr>
							<?php endforeach; ?>

							<?php if ( wc_tax_enabled() && ! WC()->cart->display_prices_including_tax() ) : ?>
								<?php if ( 'itemized' === get_option( 'woocommerce_tax_total_display' ) ) : ?>
									<?php foreach ( WC()->cart->get_tax_totals() as $code => $tax ) : // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited ?>
										<tr class="tax-rate tax-rate-<?php echo esc_attr( sanitize_title( $code ) ); ?>">
											<th><?php echo esc_html( $tax->label ); ?></th>
											<td><?php echo wp_kses_post( $tax->formatted_amount ); ?></td>
										</tr>
									<?php endforeach; ?>
								<?php else : ?>
									<tr class="tax-total">
										<th><?php echo esc_html( WC()->countries->tax_or_vat() ); ?></th>
										<td><?php wc_cart_totals_taxes_total_html(); ?></td>
									</tr>
								<?php endif; ?>
							<?php endif; ?>
							<?php do_action( 'woocommerce_review_order_before_order_total' ); ?>
							<tr class="order-total">
								<th><?php esc_html_e( 'Total', 'woocommerce' ); ?></th>
								<td><?php wc_cart_totals_order_total_html(); ?></td>
							</tr>
							<?php do_action( 'woocommerce_review_order_after_order_total' ); ?>
						</tfoot>
					</table>
				</div>
			</div>
			<div class="codesigner-payment-method-wrap">
				<div class="codesigner-payment-method-container">
					<h3><?php _e( $settings['temp-payment-methods-input'], 'codesigner-pro' );?></h3>
					<?php 
						if ( ! wp_doing_ajax() ) {
							do_action( 'woocommerce_review_order_before_payment' );
						}
						?>
						<div id="payment" class="woocommerce-checkout-payment">
							<?php if ( WC()->cart->needs_payment() ) : ?>
							<ul class="wc_payment_methods payment_methods methods">
								<?php
								$available_gateways = WC()->payment_gateways->get_available_payment_gateways();
								if ( ! empty( $available_gateways ) ) {
									foreach ( $available_gateways as $gateway ) {
										?>
										<li class="wc_payment_method payment_method_<?php echo esc_attr( $gateway->id ); ?>">
											<input id="payment_method_<?php echo esc_attr( $gateway->id ); ?>" type="radio" class="input-radio" name="payment_method" value="<?php echo esc_attr( $gateway->id ); ?>" <?php checked( $gateway->chosen, true ); ?> data-order_button_text="<?php echo esc_attr( $gateway->order_button_text ); ?>" />
											<label for="payment_method_<?php echo esc_attr( $gateway->id ); ?>">
												<?php echo $gateway->get_title(); /* phpcs:ignore WordPress.XSS.EscapeOutput.OutputNotEscaped */ ?> <?php echo $gateway->get_icon(); /* phpcs:ignore WordPress.XSS.EscapeOutput.OutputNotEscaped */ ?>												
											</label>
											<?php if ( $gateway->has_fields() || $gateway->get_description() ) : ?>
												<div class="payment_box payment_method_<?php echo esc_attr( $gateway->id ); ?>" >
													<?php $gateway->payment_fields(); ?>
												</div>
											<?php endif; ?>
										</li>
									<?php
									}
								} else {
									echo '<li>';
										wc_print_notice( apply_filters( 'woocommerce_no_available_payment_methods_message', WC()->customer->get_billing_country() ? esc_html__( 'Sorry, it seems that there are no available payment methods. Please contact us if you require assistance or wish to make alternate arrangements.', 'woocommerce' ) : esc_html__( 'Please fill in your details above to see available payment methods.', 'woocommerce' ) ), 'notice' );
									echo '</li>';
								}
								?>
							</ul>
							<?php endif; ?>
							<?php 
							wc_get_template( 'checkout/terms.php' );
							?>
							<div class="form-row place-order">
								<?php do_action( 'woocommerce_review_order_before_submit' ); ?>
								<?php $order_button_text = apply_filters( 'woocommerce_pay_order_button_text', __( $settings['order_btn_txt_temp3'], 'woocommerce' ) ); ?>
								<?php echo apply_filters( 'woocommerce_order_button_html', '<button type="submit" class="button alt' . esc_attr( 'button' ) . 'name="woocommerce_checkout_place_order" id="place_order" value="' . esc_attr( $order_button_text ) . '" data-value="' . esc_attr( $order_button_text ) . '">' . esc_html( $order_button_text ) . '</button>' ); ?>
								<?php do_action( 'woocommerce_review_order_after_submit' ); ?>
								<?php wp_nonce_field( 'woocommerce-process_checkout', 'woocommerce-process-checkout-nonce' ); ?>
							</div>
						</div>
						<?php
						if ( ! wp_doing_ajax() ) {
							do_action( 'woocommerce_review_order_after_payment' );
						}
					?>
				</div>
			</div>
		</div>
	</div>
</form>