<?php 
use Codexpert\CoDesigner_Pro\Helper;

$settings                       = $args['settings'];
$coupon_label_txt               = $settings['coupon_label_txt'];
$coupon_btn_txt                 = $settings['coupon_btn_txt'];
$coupon_desc_txt                = $settings['coupon_desc_txt'];
$coupon_apply_txt               = $settings['coupon_apply_txt'];
$billing_address_txt            = $settings['billing_address_txt'];
$shipping_address_txt           = $settings['shipping_address_txt'];
$payment_txt                    = $settings['payment_txt'];
$order_txt                      = $settings['order_txt'];
$ship_to_diffrent_addresss_text = $settings['ship_to_diffrent_addresss_text'];
$setting_order_btn_txt          = $settings['temp_1_order_btn_txt'];
$order_notes                    = $settings['order_notes_txt'];
$cart                           = WC()->cart;
$cart_contents                  = $cart->get_cart();
$settings                       = $args['settings'];
$billing_address_txt            = $settings['billing_address_txt'];
$shipping_address_txt           = $settings['shipping_address_txt'];
$payment_txt                    = $settings['payment_txt'];
$order_txt                      = $settings['order_txt'];
$cart                           = WC()->cart;
$cart_contents                  = $cart->get_cart();

if ( class_exists('WooCommerce') ) {
    $checkout        = WC()->checkout;
}

?>
<!--== Coupon Form Section Starts Here ==-->
<div id="temp1-cd-coupon">
    <div class="woocommerce-form-coupon-toggle" id="cd-coupon-form">
        <?php wc_print_notice( apply_filters( 'woocommerce_checkout_coupon_message', esc_html__( $coupon_label_txt, 'woocommerce' ) . ' <a href="#" class="showcoupon">' . esc_html__( $coupon_btn_txt, 'woocommerce' ) . '</a>' ), 'notice' ); ?>
    </div>

    <form id="cd-coupon-main" class="checkout_coupon woocommerce-form-coupon" method="post" style="display:none">

        <p><?php esc_html_e( $coupon_desc_txt, 'woocommerce' ); ?></p>

        <div class="cd-coupon-from-row">
            <p class="form-row form-row-first">
                <label for="coupon_code" class="screen-reader-text"><?php esc_html_e( 'Coupon:', 'woocommerce' ); ?></label>
                <input type="text" name="coupon_code" class="input-text" placeholder="<?php esc_attr_e( 'Coupon code', 'woocommerce' ); ?>" id="coupon_code" value="" />
            </p>
            
            <p class="form-row form-row-last">
                <button type="submit" class="button<?php echo esc_attr( 'button' ); ?>" name="apply_coupon" value="<?php esc_attr_e( 'Apply coupon', 'woocommerce' ); ?>"><?php esc_html_e( $coupon_apply_txt, 'woocommerce' ); ?></button>
            </p>
        </div>
    </form>
</div>
<!--== Coupon Form Section Ends Here ==-->

<form name="checkout" method="post" class="checkout woocommerc.e-checkout" action="<?php echo esc_url( wc_get_checkout_url() ); ?>" enctype="multipart/form-data">
    <div class="cd-checkout-template-1">
        <div class="cd-checkout-address-container">
            <!--== Billing Section Starts Here ==-->
            <div class="cd-checkout-address" id="cd-billing-section">
                <h3><?php echo esc_html__( $billing_address_txt, 'codesigner-pro' ); ?></h3>

                <?php do_action( 'woocommerce_before_checkout_billing_form', $checkout ); ?>

                <div class="woocommerce-billing-fields__field-wrapper">
                    <?php
                        $fields = $checkout->get_checkout_fields( 'billing' );

                        foreach ( $fields as $key => $field ) {
                            woocommerce_form_field( $key, $field, $checkout->get_value( $key ) );
                        }
                    ?>
                </div>

                <?php do_action( 'woocommerce_after_checkout_billing_form', $checkout ); ?>
            </div>
            <!--== Billing Section Ends Here ==-->
            <div class="different-address-shipping">
                <input id="ship-different" type="checkbox">
                <label for="ship-different">
                    <?php esc_html_e( $ship_to_diffrent_addresss_text , 'codesigner-pro' ); ?>
                </label>
            </div>
            <!--== Shipping Section Starts Here ==-->
            <div class="cd-checkout-address cd-checkout-shipping" id="cd-shipping-section">
                <h3><?php echo esc_html__( $shipping_address_txt , 'codesigner-pro' ); ?></h3>
                <?php do_action( 'woocommerce_before_checkout_shipping_form', $checkout ); ?>

                <div class="woocommerce-shipping-fields__field-wrapper" style="display: block;">
                    <?php
                        $fields = $checkout->get_checkout_fields( 'shipping' );

                        foreach ( $fields as $key => $field ) {
                            woocommerce_form_field( $key, $field, $checkout->get_value( $key ) );
                        }
                    ?>
                </div>
                <?php do_action( 'woocommerce_after_checkout_shipping_form', $checkout ); ?>
            </div>
            <!--== Shipping Section Ends Here ==-->
            <div class="order-notes">
                <p class="form-row notes" id="order_comments_field">
                    <label for="order_comments"><?php _e( $order_notes , 'woocommerce'); ?></label>
                    <textarea name="order_comments" class="input-text" id="order_comments" placeholder="<?php esc_attr_e('Notes about your order, e.g. special notes for delivery.', 'woocommerce'); ?>"></textarea>
                </p>
    
            </div>
        </div>
        <!--== Order Summury Section Starts Here ==-->
        <div class="cd-checkout-order-container">
            <div id="cd-checkout-order-id" class="cd-checkout-order">
                <h3><?php echo esc_html__( $order_txt , 'codesigner-pro' ); ?></h3>
                <div class="cd-checkout-table-wrapper">
                    <table id="cd-checkout-table">
                        <thead>
                            <tr>
                                <th class="product-name"><?php esc_html_e( 'Product', 'woocommerce' ); ?></th>
                                <th></th>
                                <th></th>
                                <th class="product-total"><?php esc_html_e( 'Subtotal', 'woocommerce' ); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                                do_action( 'woocommerce_review_order_before_cart_contents' );

                                foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
                                    $_product   = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
                                    $image      = $_product->get_image(); 
                                    if ( $_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters( 'woocommerce_checkout_cart_item_visible', true, $cart_item, $cart_item_key ) ) {
                                        ?>
                                        <tr class="<?php echo esc_attr( apply_filters( 'woocommerce_cart_item_class', 'cart_item', $cart_item, $cart_item_key ) ); ?>">
                                            <td class="cd_checkout_product_img"> 
                                                <?php 
                                                    echo $image;
                                                ?>
                                            </td>
                                            <td class="cd_checkout_product_title">
                                                <p class="product-title"><?php echo esc_html( $_product->get_title() );?></p>
                                            </td>
                                            <td class="cd_checkout_product_quantity">
                                                <p> &times;<?php echo $cart_item['quantity']; ?> </p>
                                                 <?php echo wc_get_formatted_cart_item_data( $cart_item ); ?>
                                            </td>
                                            <td class="cd_checkout_product_price">
                                                <p><?php echo apply_filters( 'woocommerce_cart_item_subtotal', WC()->cart->get_product_subtotal( $_product, $cart_item['quantity'] ), $cart_item, $cart_item_key ) ;?></p>
                                            </td>
                                        </tr>
                                        <?php
                                    }
                                }
                                do_action( 'woocommerce_review_order_after_cart_contents' );
                            ?>
                        </tbody>
                        <table class="woocommerce-checkout-review-order-table" id="cd-checkout-tfoot-wrap">
                            <tfoot id="cd-checkout-tfoot">
                                <tr class="cart-subtotal">
                                    <th><?php esc_html_e( 'Subtotal', 'woocommerce' ); ?></th>
                                    <td><?php wc_cart_totals_subtotal_html(); ?></td>
                                </tr>
                                <?php foreach ( WC()->cart->get_coupons() as $code => $coupon ) : ?>
                                    <tr class="cart-discount coupon-<?php echo esc_attr( sanitize_title( $code ) ); ?>">
                                        <th><?php wc_cart_totals_coupon_label( $coupon ); ?></th>
                                        <td><?php wc_cart_totals_coupon_html( $coupon ); ?></td>
                                    </tr>
                                <?php endforeach; ?>

                                <?php if ( WC()->cart->needs_shipping() && WC()->cart->show_shipping() ) : ?>
                                    <?php do_action( 'woocommerce_review_order_before_shipping' ); ?>
                                    <?php WC()->cart->calculate_totals(); ?>
                                    <?php wc_cart_totals_shipping_html(); ?>
                                    <?php do_action( 'woocommerce_review_order_after_shipping' ); ?>
                                <?php endif; ?>

                                <?php foreach ( WC()->cart->get_fees() as $fee ) : ?>
                                    <tr class="fee">
                                        <th><?php echo esc_html( $fee->name ); ?></th>
                                        <td><?php wc_cart_totals_fee_html( $fee ); ?></td>
                                    </tr>
                                <?php endforeach; ?>

                                <?php if ( wc_tax_enabled() && ! WC()->cart->display_prices_including_tax() ) : ?>
                                    <?php if ( 'itemized' === get_option( 'woocommerce_tax_total_display' ) ) : ?>
                                        <?php foreach ( WC()->cart->get_tax_totals() as $code => $tax ) : ?>
                                            <tr class="tax-rate tax-rate-<?php echo esc_attr( sanitize_title( $code ) ); ?>">
                                                <th><?php echo esc_html( $tax->label ); ?></th>
                                                <td><?php echo wp_kses_post( $tax->formatted_amount ); ?></td>
                                            </tr>
                                        <?php endforeach; ?>
                                    <?php else : ?>
                                        <tr class="tax-total">
                                            <th><?php echo esc_html( WC()->countries->tax_or_vat() ); ?></th>
                                            <td><?php wc_cart_totals_taxes_total_html(); ?></td>
                                        </tr>
                                    <?php endif; ?>
                                <?php endif; ?>
                                <?php do_action( 'woocommerce_review_order_before_order_total' ); ?>
                                <tr class="order-total">
                                    <th><?php esc_html_e( 'Total' , 'woocommerce' ); ?></th>
                                    <td><?php wc_cart_totals_order_total_html(); ?></td>
                                </tr>
                                <?php do_action( 'woocommerce_review_order_after_order_total' ); ?>
                            </tfoot>
                        </table>
                        
                    </table>
                </div>
                <div class="cd-checkout-payment" id="cd-payment-method">
                    <h3><?php echo esc_html__( $payment_txt, 'codesigner-pro' ); ?></h3>               
                    <?php
                        if ( ! wp_doing_ajax() ) {
                            do_action( 'woocommerce_review_order_before_payment' );
                        }
                    ?>
                    <div id="payment" class="woocommerce-checkout-payment">
                        <?php if ( WC()->cart->needs_payment() ) : ?>
                            <ul class="wc_payment_methods payment_methods methods">
                                <?php
                                $available_gateways = WC()->payment_gateways->get_available_payment_gateways();
                                if ( ! empty( $available_gateways ) ) {
                                    foreach ( $available_gateways as $gateway ) {
                                        ?>
                                        <li class="wc_payment_method payment_method_<?php echo esc_attr( $gateway->id ); ?>">
                                            <input id="payment_method_<?php echo esc_attr( $gateway->id ); ?>" type="radio" class="input-radio" name="payment_method" value="<?php echo esc_attr( $gateway->id ); ?>" <?php checked( $gateway->chosen, true ); ?> data-order_button_text="<?php echo esc_attr( $gateway->order_button_text ); ?>" />

                                            <label for="payment_method_<?php echo esc_attr( $gateway->id ); ?>">
                                                <?php echo $gateway->get_title(); ?> <?php echo $gateway->get_icon(); ?>
                                            </label>
                                            <?php if ( $gateway->has_fields() || $gateway->get_description() ) : ?>
                                                <div id="cd-payment-description" class="payment_box payment_method_<?php echo esc_attr( $gateway->id ); ?>">
                                                    <?php $gateway->payment_fields(); ?>
                                                </div>
                                            <?php endif; ?>
                                        </li>
                                        <?php
                                    }
                                } else {
                                    echo '<li>';
                                    wc_print_notice( apply_filters( 'woocommerce_no_available_payment_methods_message', WC()->customer->get_billing_country() ? esc_html__( 'Sorry, it seems that there are no available payment methods. Please contact us if you require assistance or wish to make alternate arrangements.', 'woocommerce' ) : esc_html__( 'Please fill in your details above to see available payment methods.', 'woocommerce' ) ), 'notice' );
                                    echo '</li>';
                                }
                                ?>
                            </ul>
                        <?php endif; ?>
                        <?php 
                            wc_get_template( 'checkout/terms.php' );
                        ?>
                        <div class="form-row place-order">
                            <?php do_action( 'woocommerce_review_order_before_submit' ); ?>
                            <?php $order_button_text = apply_filters( 'woocommerce_pay_order_button_text', __( $setting_order_btn_txt, 'woocommerce' ) ); ?>
                            <?php echo apply_filters( 'woocommerce_order_button_html', '<button type="submit" class="button alt' . esc_attr('button' ) . ' name="woocommerce_checkout_place_order" id="place_order" value="' . esc_attr( $order_button_text ) . '" data-value="' . esc_attr( $order_button_text ) . '">' . esc_html( $order_button_text ) . '</button>' ); ?>

                            <?php do_action( 'woocommerce_review_order_after_submit' ); ?>

                            <?php wp_nonce_field( 'woocommerce-process_checkout', 'woocommerce-process-checkout-nonce' ); ?>
                        </div>
                    </div>
                    <?php
                        if ( ! wp_doing_ajax() ) {
                            do_action( 'woocommerce_review_order_after_payment' );
                        }
                    ?> 
                </div>
            </div>
        <!--== Order Summury Section Ends Here===-->
    </div>
</form>


