<?php

if( ! function_exists( 'codesigner_get_checkout_template' ) ) :
    function codesigner_get_checkout_template( $args ) {
        // default template directory
        $checkout_template_dir   = dirname( CODESIGNER_PRO ) . "/modules/checkout-builder/templates/";

        // full path of a template file in module directory
        $checkout_template_path  = $checkout_template_dir . $args['template-slug'] . '.php';

        if ( file_exists( $checkout_template_path ) ) {
            ob_start();
            include $checkout_template_path;
            return ob_get_clean();
        }
        else return;
    }
endif;

if( ! function_exists( 'codesigner_get_checkout_template_controls' ) ) :
    function codesigner_get_checkout_template_controls( $args ) {
        // default template controls directory
        $controls_dir   = dirname( CODESIGNER_PRO ) . "/modules/checkout-builder/controls/";

        // full path of a template file in module directory
        $controls_path  = $controls_dir . $args['control-slug'] . '.php';

        if ( file_exists( $controls_path ) ) {
            ob_start();
            include $controls_path;
            return ob_get_clean();
        }
        else return;
    }
endif;

/**
 * Get checkout builder template file name list
 * 
 * @return array filename_list
 */
if (!function_exists('codesigner_get_checkout_templates_list') ) :
    function codesigner_get_checkout_templates_list( $name = false ) {
        $templates = [
            'default',
            'template-1',
            'template-2',
            'template-3',
            'template-4',
            'template-5',
            'template-6',
            'template-7'
        ];

        $formatted_templates = [];
        foreach ( $templates as $template ) {
            $formatted_templates[$template] = $name ?
                esc_html__( ucwords( str_replace( '-', ' ', $template ) ), 'codesigner-pro' ) :
                $template;
        }

        return $formatted_templates;

    }
endif;






