<?php

use Codexpert\CoDesigner\Helper;
use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Text_Stroke;

// Exit if accessed directly

if ( ! defined( 'ABSPATH' ) ) {
	exit; 
}

$widget = $args['this'];

$widget->start_controls_section(
    'temp1_heading_text',
    [
        'label'      => __( 'Heading Text', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_CONTENT,
        'condition'  => [
            'cd_checkout_template' => 'template-1',
        ],
    ]
);
$widget->add_control(
    'billing_address_txt',
    [
        'label'         => __( 'Billing Text', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'Billing Summury', 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
    ]
);
$widget->add_control(
    'ship_to_diffrent_addresss_text',
    [
        'label'         => __( 'Ship to Text', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'Ship to a different address?', 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
    ]
);
$widget->add_control(
    'shipping_address_txt',
    [
        'label'         => __( 'Shipping Text', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'Shipping Summury', 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
    ]
);
$widget->add_control(
    'order_notes_txt',
    [
        'label'         => __( 'Order Notes', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'Order notes(Optional)', 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
    ]
);
$widget->add_control(
    'order_txt',
    [
        'label'         => __( 'Order Text', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'Order Summary', 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
    ]
);
$widget->add_control(
    'payment_txt',
    [
        'label'         => __( 'Payment Text', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'Payment Methods', 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
    ]
);

$widget->end_controls_section();

$widget->start_controls_section(
    'temp1_order_text',
    [
        'label'      => __( 'Order Button', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_CONTENT,
        'condition'  => [
            'cd_checkout_template' => 'template-1',
        ],
    ]
);
$widget->add_control(
    'temp_1_order_btn_txt',
    [
        'label'         => __( 'Order btn Text', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'Place Order', 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
    ]
);
$widget->end_controls_section();

$widget->start_controls_section(
    'cd_checkout_template1',
    [
        'label'      => __( 'Checkout Background', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-1',
        ],
    ]
);
$widget->add_control(
    'cd_checkout-template1-background',
    [
        'label' 	=> esc_html__( 'Background Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-checkout-address-container' => 'background: {{VALUE}} ',
        ],
    ]
);
$widget->end_controls_section();
$widget->start_controls_section(
    'cd_checkout_template1_coupon_form',
    [
        'label'      => __( 'Coupon Form', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-1',
        ],
    ]
);
$widget->start_controls_tabs(
    'cd_checkout_template1_coupon_form_control'
);
$widget->start_controls_tab(
    'cd_checkout_template1_coupon_form_text_tab',
    [
        'label' => esc_html__( 'Text', 'codesigner-pro' ),
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_template1_coupon_form_typography',
        'selector'  => '{{WRAPPER}} #cd-coupon-form .woocommerce-info,
                        {{WRAPPER}} #cd-coupon-main p ',
    ]
);
$widget->add_control(
    'cd_checkout_template1_coupon_form_color',
    [
        'label' 	=> esc_html__( 'Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-coupon-form .woocommerce-info' => 'color: {{VALUE}} ',
            '{{WRAPPER}} #cd-coupon-main p'                 => 'color: {{VALUE}} ',
        ],
    ]
);
$widget->add_control(
    'cd_checkout_template1_coupon_form_input_color',
    [
        'label' 	=> esc_html__( 'Input Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-coupon-main .form-row input::placeholder' => 'color: {{VALUE}} ',
        ],
    ]
);
$widget->add_control(
    'cd_checkout_template1_coupon_form_input_color_bg',
    [
        'label' 	=> esc_html__( 'Input background', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-coupon-main .form-row input' => 'background: {{VALUE}} ',
        ],
    ]
);
$widget->add_responsive_control(
    'cd_checkout_template1_coupon_form_input_border_radius',
    [
        'type'       => Controls_Manager::DIMENSIONS,
        'label'      => esc_html__( 'Input Border Radius', 'codesigner-pro' ),
        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors'  => [
            '{{WRAPPER}} #cd-coupon-main .form-row input' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);
$widget->end_controls_tab();

$widget->start_controls_tab(
    'cd_checkout_template1_coupon_form_button_tab',
    [
        'label' => esc_html__( 'Button', 'codesigner-pro' ),
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_template1_coupon_form_button_typography',
        'selector'  => '{{WRAPPER}} #cd-coupon-form a.showcoupon,
                        {{WRAPPER}} #cd-coupon-main .form-row-last button',
    ]
);
$widget->add_control(
    'cd_checkout_template1_coupon_form_button_color',
    [
        'label' 	=> esc_html__( 'Button Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-coupon-form a.showcoupon'           => 'color: {{VALUE}} ',
            '{{WRAPPER}} #cd-coupon-main .form-row-last button'  => 'color: {{VALUE}} ',
        ],
    ]
);
$widget->add_control(
    'cd_checkout_template1_coupon_form_button_background_color',
    [
        'label' 	=> esc_html__( 'Background Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-coupon-form a.showcoupon'           => 'background: {{VALUE}} ',
            '{{WRAPPER}} #cd-coupon-main .form-row-last button'  => 'background: {{VALUE}} ',
        ],
    ]
);
$widget->add_responsive_control(
    'cd_checkout_template1_coupon_form_button_border_radius',
    [
        'type'       => Controls_Manager::DIMENSIONS,
        'label'      => esc_html__( 'Border Radius', 'codesigner-pro' ),
        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors'  => [
            '{{WRAPPER}} #cd-coupon-form a.showcoupon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            '{{WRAPPER}} #cd-coupon-main .form-row-last button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);
$widget->end_controls_tab();
$widget->end_controls_tabs();
$widget->end_controls_section();

$widget->start_controls_section(
    'cd_checkout_template1_billing_heading',
    [
        'label'      => __( 'Checkout Heading', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-1',
        ],
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_template1_heading_typography',
        'selector'  => '{{WRAPPER}} .cd-checkout-address-container h3',
    ]
);
$widget->add_control(
    'cd_checkout_template1_heading_color',
    [
        'label'     => esc_html__( 'Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-checkout-address-container h3' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->add_control(
    'cd_checkout_template1_billing_border_color',
    [
        'label' 	=> esc_html__( 'Border Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-checkout-address-container h3' => 'border-color: {{VALUE}}',
        ],
    ]
);
$widget->end_controls_section();

$widget->start_controls_section(
    'cd_checkout_template1_billing_form_style',
    [
        'label'      => __( 'Billing & Shipping Form', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-1',
        ],
    ]
);
$widget->start_controls_tabs(
    'cd_checkout_template1_billing_form_design'
);
$widget->start_controls_tab(
    'cd_checkout_template1_form_message_tab',
    [
        'label' => esc_html__( 'Label', 'codesigner-pro' ),
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'       => 'cd_checkout_template1_form_message_typography',
        'selector'   => ' {{WRAPPER}} #cd-billing-section .form-row label,
                         {{WRAPPER}} #cd-shipping-section .form-row label'     
    ]
);

$widget->add_control(
    'cd_checkout_template1_form_message_color',
    [
        'label'     => esc_html__( 'Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            ' {{WRAPPER}} #cd-billing-section .form-row label '    => 'color: {{VALUE}};' ,
            ' {{WRAPPER}} #cd-shipping-section .form-row label '   => 'color: {{VALUE}};'
        ],
    ]
);
$widget->end_controls_tab();
$widget->start_controls_tab(
    'cd_checkout_template1_form_input_tab',
    [
        'label' => esc_html__( 'Input', 'codesigner-pro' ),
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_template1_form_input_typography',
        'selector'  => '{{WRAPPER}} .woocommerce-input-wrapper input,
                        {{WRAPPER}} .woocommerce-input-wrapper select,
                        {{WRAPPER}} .woocommerce-input-wrapper select .select2-selection'

    ]
);
$widget->add_control(
    'cd_checkout_template1_form_input_color',
    [
        'label'     => esc_html__( 'Placeholder Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .woocommerce-input-wrapper input '            => 'color: {{VALUE}}',
            '{{WRAPPER}} .woocommerce-input-wrapper select '           => 'color: {{VALUE}}',
            '{{WRAPPER}} .woocommerce-input-wrapper input input:focus' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->add_control(
    'cd_checkout_template1_form_input_background',
    [
        'label'     => esc_html__( 'Background', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-billing-section .form-row input'          => 'background: {{VALUE}}',
            '{{WRAPPER}} #cd-billing-section .form-row select'         => 'background: {{VALUE}}',
            '{{WRAPPER}} #cd-shipping-section .form-row input'         => 'background: {{VALUE}}',
            '{{WRAPPER}} #cd-shipping-section .form-row select'        => 'background: {{VALUE}}',
            '{{WRAPPER}} .woocommerce-js .select2-container--default .select2-selection--single .select2-selection__rendered' => 'background: {{VALUE}} ',
        ],
    ]
);
$widget->add_group_control(
    Group_Control_Box_Shadow::get_type(),
    [
        'name' 		=> 'cd_checkout_template1_form_input_box_shadow',
        'selector' 	=> '{{WRAPPER}} #cd-billing-section .form-row input, 
                        {{WRAPPER}} #cd-billing-section .form-row select,
                        {{WRAPPER}} #cd-shipping-section .form-row input,
                        {{WRAPPER}} #cd-shipping-section .form-row select' 
    ]
);
$widget->add_responsive_control(
    'cd_checkout_template1_form_input_padding',
    [
        'type'       => Controls_Manager::DIMENSIONS,
        'label'      => esc_html__( 'Padding', 'codesigner-pro' ),
        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors'  => [
            '{{WRAPPER}} .woocommerce-input-wrapper input '  => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            '{{WRAPPER}} .woocommerce-input-wrapper select ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);
$widget->end_controls_tab();
$widget->end_controls_tabs();
$widget->end_controls_section();

$widget->start_controls_section (
    'cd_checkout_template1_order_notes_label',
    [
        'label'      => __( 'Order Notes', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-1',
        ],
    ]
);
$widget->start_controls_tabs(
    'cd_checkout_template1_order_notes_form_design'
);
$widget->start_controls_tab(
    'cd_checkout_template1_order_notes_label_tab',
    [
        'label' => esc_html__( 'Label', 'codesigner-pro' ),
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'       => 'cd_checkout_template1_order_notes_typography',
        'selector'   => '{{WRAPPER}} .order-notes .form-row label '     
    ]
);
$widget->add_control(
    'cd_checkout_template1_order_notes_label_color',
    [
        'label'     => esc_html__( 'Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .order-notes .form-row label' => 'color: {{VALUE}};'
        ],
    ]
);
$widget->end_controls_tab();
$widget->start_controls_tab(
    'cd_checkout_template1_order_notes_input_tab',
    [
        'label' => esc_html__( 'Input', 'codesigner-pro' ),
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_template1_order_notes_input_typography',
        'selector'  => '{{WRAPPER}} .order-notes .form-row textarea  '

    ]
);
$widget->add_control(
    'cd_checkout_template1_order_notes_input_color_placeholder',
    [
        'label'     => esc_html__( 'Placeholder Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .order-notes textarea#order_comments::placeholder'   => 'color: {{VALUE}}',
        ],
    ]
);
$widget->add_control(
    'cd_checkout_template1_order_notes_input_background',
    [
        'label'     => esc_html__( 'Background', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .order-notes .form-row textarea' => 'background: {{VALUE}}',
        ],
    ]
);
$widget->add_group_control(
    Group_Control_Box_Shadow::get_type(),
    [
        'name' 		=> 'cd_checkout_template1_order_notes_input_box_shadow',
        'selector' 	=> ' {{WRAPPER}} .order-notes .form-row textarea ' 
    ]
);
$widget->add_responsive_control(
    'cd_checkout_template1_order_notes_input_padding',
    [
        'type'       => Controls_Manager::DIMENSIONS,
        'label'      => esc_html__( 'Padding', 'codesigner-pro' ),
        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors'  => [
            '{{WRAPPER}} .order-notes .form-row textarea '   => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);
$widget->end_controls_tab();
$widget->end_controls_tabs();
$widget->end_controls_section();

$widget->start_controls_section(
    'cd_checkout_template1_order_heading',
    [
        'label'      => __( 'Order Heading', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-1',
        ],
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_template1_order_heading_typography',
        'selector'  => '{{WRAPPER}} .cd-checkout-order-container h3',
    ]
);

$widget->add_control(
    'cd_checkout_template1_order_heading_color',
    [
        'label'     => esc_html__( 'Heading Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-checkout-order-container h3' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->end_controls_section();

$widget->start_controls_section(
    'cd_checkout_template1_order_details_design',
    [
        'label'      => __( 'Order Details Table', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-1',
        ],
    ]
);
$widget->start_controls_tabs (
    'cd_checkout_template1_details_order_style_tabs'
);
$widget->start_controls_tab(
    'cd_checkout_template1_order_details_heading',
    [
        'label' 	=> esc_html__( 'Table Heading', 'codesigner-pro' ),
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_template1_table_heading_typography',
        'selector'  => '{{WRAPPER}} #cd-checkout-order-id #cd-checkout-table thead tr th',
    ]
);
$widget->add_control(
    'cd_checkout_template1_order_details_heading_color',
    [
        'label' 	=> esc_html__( 'Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-checkout-order-id #cd-checkout-table thead tr th ' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->end_controls_tab();

$widget->start_controls_tab(
    'cd_checkout_template1_order_details_body',
    [
        'label' 	=> esc_html__( 'Table Body', 'codesigner-pro' ),
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_template1_table_order_details_body_typography',
        'selectors' => '{{WRAPPER}} #cd-checkout-order-id .cd_checkout_product_title p,
                       {{WRAPPER}} #cd-checkout-order-id .cd_checkout_product_quantity p,
                       {{WRAPPER}} #cd-checkout-order-id .cd_checkout_product_price p,
                       {{WRAPPER}} #cd-checkout-order-id .cart-subtotal,
                       {{WRAPPER}} #cd-checkout-order-id .order-total,
                       {{WRAPPER}} .cd-order-table-product span',
    ]
);
$widget->add_control(
    'cd_checkout_template1_order_details_body_color',
    [
        'label' 	=> esc_html__( 'Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-checkout-order-id .cd_checkout_product_title p'    => 'color: {{VALUE}}',
            '{{WRAPPER}} #cd-checkout-order-id .cd_checkout_product_quantity p' => 'color: {{VALUE}}',
            '{{WRAPPER}} #cd-checkout-order-id .cd_checkout_product_price p'    => 'color: {{VALUE}}',
            '{{WRAPPER}} #cd-checkout-order-id .cart-subtotal'                  => 'color: {{VALUE}}',
            '{{WRAPPER}} #cd-checkout-order-id .woocommerce-shipping-totals th' => 'color: {{VALUE}}',
            '{{WRAPPER}} #cd-checkout-order-id .woocommerce-shipping-totals td' => 'color: {{VALUE}}',
            '{{WRAPPER}} #cd-checkout-order-id .order-total'                    => 'color: {{VALUE}}',
            '{{WRAPPER}} .cd-order-table-product span'                          => 'color: {{VALUE}}',
        ],
    ]
);
$widget->add_control(
    'cd_checkout_template1_order_section_border_color',
    [
        'label' 	=> esc_html__( 'Border Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-checkout-address-container h3'                      => 'border-color: {{VALUE}}',
            '{{WRAPPER}} .cd-checkout-template-1 .cd-checkout-table-wrapper '    => 'border-color: {{VALUE}}',
            '{{WRAPPER}} .cd-checkout-template-1 #cd-checkout-table thead tr th' => 'border-color: {{VALUE}}'
        ],
    ]
);
$widget->add_responsive_control(
    'cd_checkout_template1_table_body_image_control',
    [
        'type'   => Controls_Manager::SLIDER,
        'label'  => esc_html__( 'Image Sizing', 'codesigner-pro' ),
        'range'  => [
            'px' => [
                'min' => 0,
                'max' => 100,
            ],
        ],
        'devices'         => [ 'desktop', 'tablet', 'mobile' ],
        'desktop_default' => [
            'size' => 64,
            'unit' => 'px',
        ],
        'tablet_default' => [
            'size' => 48,
            'unit' => 'px',
        ],
        'mobile_default' => [
            'size' => 32,
            'unit' => 'px',
        ],
        'selectors' => [
            '{{WRAPPER}} #cd-checkout-order-id .cd_checkout_product_img img' => 'width: {{SIZE}}{{UNIT}};',
        ],
    ]
);
$widget->add_responsive_control(
    'cd_checkout_template1_product_image_border_radius',
    [
        'type'       => Controls_Manager::DIMENSIONS,
        'label'      => esc_html__( 'Image Border Radius', 'codesigner-pro' ),
        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors'  => [
            '{{WRAPPER}} #cd-checkout-order-id .cd_checkout_product_img img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);
$widget->end_controls_tab();
$widget->end_controls_tabs();
$widget->end_controls_section();

$widget->start_controls_section(
    'cd_checkout_template1_ship_to_different',
    [
        'label'      => __( 'Ship to different input', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-1',
        ],
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_template1_ship_to_different_typography',
        'selector'  => '{{WRAPPER}} .different-address-shipping label',
    ]
);
$widget->add_control(
    'cd_checkout_template1_ship_to_different_color',
    [
        'label' 	=> esc_html__( 'Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .different-address-shipping label' => 'color: {{VALUE}} ',
        ],
    ]
);
$widget->end_controls_section();

$widget->start_controls_section(
    'cd_checkout_template1_payment_section',
    [
        'label'      => __( 'Payment Section', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-1',
        ],
    ]
);
$widget->start_controls_tabs (
    'cd_checkout_template1_payment_section_order_style_tabs'
);
$widget->start_controls_tab(
    'cd_checkout_template1_payment_section_Label',
    [
        'label' 	=> esc_html__( 'Label', 'codesigner-pro' ),
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_template1_table_payment_section_heading_typography',
        'selector'  => '{{WRAPPER}} ul.wc_payment_methods.payment_methods.methods label',
    ]
);

$widget->add_control(
    'cd_checkout_template1_payment_section_background',
    [
        'label' 	=> esc_html__( 'Section Background', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} ul.wc_payment_methods.payment_methods.methods' => 'background: {{VALUE}} ',
        ],
    ]
);
$widget->add_control(
    'cd_checkout_template1_payment_section_heading_color',
    [
        'label' 	=> esc_html__( 'Section Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} ul.wc_payment_methods.payment_methods.methods label' => 'color: {{VALUE}} ',
        ],
    ]
);
$widget->add_responsive_control(
    'cd_checkout_template1_payment_section_whole_box_border_radius',
    [
        'type'       => Controls_Manager::DIMENSIONS,
        'label'      => esc_html__( 'Section Border Radius', 'codesigner-pro' ),
        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors'  => [
            '{{WRAPPER}} #payment ul.payment_methods ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);
$widget->end_controls_tab();
$widget->start_controls_tab(
    'cd_checkout_template1_payment_section_description',
    [
        'label' 	=> esc_html__( 'Description', 'codesigner-pro' ),
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_template1_table_payment_section_description_typography',
        'selector'  => '{{WRAPPER}} .wc_payment_method .payment_method_bacs p ,
                        {{WRAPPER}} .wc_payment_method .payment_method_cod p',
    ]
);
$widget->add_control(
    'cd_checkout_template1_table_payment_section_description_color',
    [
        'label'     => esc_html__( 'Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .wc_payment_method .payment_method_bacs p ' => 'color: {{VALUE}}',
            '{{WRAPPER}} .wc_payment_method .payment_method_cod p '  => 'color: {{VALUE}}',
        ],
    ]
);
$widget->add_control(
    'cd_checkout_template1_table_payment_section_description_background',
    [
        'label' 	=> esc_html__( 'Box Background', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #payment #cd-payment-description'   => 'background: {{VALUE}} ',
            '{{WRAPPER}} #payment div.payment_box::before'   => 'border-bottom-color: {{VALUE}} ',
        ],
    ]
);
$widget->add_responsive_control(
    'cd_checkout_template1_order_payment_section_box_border_radius',
    [
        'label'     => esc_html__( 'Box Border Radius', 'codesigner-pro' ),
        'type'      => Controls_Manager::DIMENSIONS,
        'size_units'=> [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors' => [
            '{{WRAPPER}} #payment #cd-payment-description ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);
$widget->end_controls_tab();
$widget->end_controls_tabs();
$widget->end_controls_section();

$widget->start_controls_section(
    'cd_checkout_template1_Order_button',
    [
        'label'      => __( 'Order Button', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-1',
        ],
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_template1_order_button_background_typography',
        'selector'  => '{{WRAPPER}} button#place_order',
    ]
);
$widget->add_control(
    'cd_checkout_template1_order_button_background',
    [
        'label' 	=> esc_html__( 'Background Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} button#place_order ' => 'background: {{VALUE}}',
        ],
    ]
);
$widget->add_responsive_control(
    'cd_checkout_template1_order_button_border_radius',
    [
        'type'       => Controls_Manager::DIMENSIONS,
        'label'      => esc_html__( 'Border Radius', 'codesigner-pro' ),
        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors'  => [
            '{{WRAPPER}} button#place_order' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);
$widget->add_group_control(
    Group_Control_Box_Shadow::get_type(),
    [
        'name' 		=> 'cd_checkout_template1_order_button_box_shadow',
        'selector' 	=> '{{WRAPPER}} button#place_order',
    ]
);
$widget->add_control(
    'cd_checkout_template1_order_button_color',
    [
        'label'     => esc_html__( 'Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} button#place_order' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->end_controls_section();

$widget->start_controls_section(
    'cd_checkout_template1_terms_and_policy',
    [
        'label'      => __( 'Terms and Policy', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-1',
        ],
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_template1_terms_and_policy_typography',
        'selector'  => '{{WRAPPER}} .cd-checkout-template-1 .woocommerce-terms-and-conditions-checkbox-text',
    ]
);
$widget->add_control(
    'cd_checkout_template1_terms_and_policy_color',
    [
        'label'     => esc_html__( 'Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-checkout-template-1 .woocommerce-terms-and-conditions-checkbox-text ' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->end_controls_section();