jQuery(function($){
    $(document).ready(function(){
  
      //Toggle when click ship to different address
      $(document).on('click', "#ship-to-different-address-checkbox[type='checkbox']", function(){
        $('.woocommerce-shipping-fields__field-wrapper').slideToggle();
        $('.shipping-address-wrap h3').toggleClass('codesigner-shipping-address-mb');
      });

      $( ".temp-3 .cd-cart-quatity" ).on( 'click', function (){
        addOrRamove = $(this).attr( 'data-attr' );
        productID 	= $(this).attr( 'product-id' );

        item_quantity_value = $(".cd-cart-item-quantity").val();

        $.ajax({
          url: CODESIGNER_PRO.ajaxurl,
          data: {
            'action' : 'checkout_template_quantity_add_or_remove',
          nonce: CODESIGNER_PRO._nonce,
          product_id: productID,
          addOrRamove: addOrRamove,
          },
          type: 'POST',
          dataType: 'JSON',
          success: function( resp ) {
            //update price on time
            $('.cart-subtotal td .woocommerce-Price-amount.amount').replaceWith(resp.data.subtotal);
            $('.tax-rate td .woocommerce-Price-amount.amount').replaceWith(resp.data.tax);
            $('.order-total td .woocommerce-Price-amount.amount').replaceWith(resp.data.total);


            if ( 'remove' == addOrRamove ) {
              var currentValue = $(`.cd-set-quantity-${productID}`).val();
              
              var newValue = parseInt(currentValue, 10) - 1;
              $(`.cd-set-quantity-${productID}`).val(newValue);
              if ( newValue == 0 ) {
                $(`.cd-product-id-${productID}`).remove();
              }
            }
            else if( 'add' == addOrRamove ) {
              var currentValue = $(`.cd-set-quantity-${productID}`).val();
              var newValue = parseInt(currentValue, 10) + 1;
              $(`.cd-set-quantity-${productID}`).val(newValue);			
            }
          }
        });
      });
    
      $('.temp-3 .cd-cart-item-quantity').on('blur', function(){
        productID = $(this).attr( 'product-id' );
        quantity 	= $(this).val();

        $.ajax({
          url: CODESIGNER_PRO.ajaxurl,
          data: {
                'action' : 'checkout_template_customize_quantity',
          nonce: CODESIGNER_PRO._nonce,
          product_id: productID,
          quantity: quantity,
        },
          type: 'POST',
          dataType: 'JSON',
          success: function( resp ) {
            // console.log( resp );
            //update price on time
            $('.cart-subtotal td .woocommerce-Price-amount.amount').replaceWith(resp.data.subtotal);
            $('.tax-rate td .woocommerce-Price-amount.amount').replaceWith(resp.data.tax);
            $('.order-total td .woocommerce-Price-amount.amount').replaceWith(resp.data.total);
          }
        });
      });
  
    });
  });
  
  
  
  