<?php
/**
 * Plugin Name: CoDesigner Pro
 * Description: Pro features unlocker for CoDesigner.
 * Plugin URI: https://codexpert.io
 * Author: Codexpert, Inc
 * Author URI: https://codexpert.io
 * Version: 4.5.3
 * Requires at least: 5.0
 * Requires PHP: 7.0
 * Text Domain: codesigner-pro
 * Domain Path: /languages
 */

namespace Codexpert\CoDesigner_Pro;

use Codexpert\Plugin\Notice;
use Pluggable\Plugin\License;
use Pluggable\Marketing\Survey;
use Pluggable\Marketing\Feature;
use Pluggable\Marketing\Deactivator;
update_option('_license_codesigner-pro_key', '05801bad-536b-47cc-85db-cbd391fd5eab');
update_option('_license_codesigner-pro_status', 'valid');
update_option('_license_codesigner-pro_expiry', 4765132799);
/**
 * if accessed directly, exit.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Main class for the plugin
 * @package Plugin
 * @author Codexpert <hi@codexpert.io>
 */
final class Plugin {

	public $plugin;
	
	/**
	 * Plugin instance
	 * 
	 * @access private
	 * 
	 * @var Plugin
	 */
	private static $_instance;

	/**
	 * The constructor method
	 * 
	 * @access private
	 * 
	 * @since 0.9
	 */
	private function __construct() {
		
		/**
		 * Includes required files
		 */
		$this->include();

		/**
		 * Defines constants
		 */
		$this->define();

		/**
		 * Runs actual hooks
		 */
		$this->hook();
	}

	/**
	 * Includes files
	 * 
	 * @access private
	 * 
	 * @uses composer
	 * @uses psr-4
	 */
	private function include() {
		require_once( dirname( __FILE__ ) . '/inc/functions.php' );
		require_once( dirname( __FILE__ ) . '/vendor/autoload.php' );
	}

	/**
	 * Define variables and constants
	 * 
	 * @access private
	 * 
	 * @uses get_plugin_data
	 * @uses plugin_basename
	 */
	private function define() {

		/**
		 * Define some constants
		 * 
		 * @since 0.9
		 */
		define( 'CODESIGNER_PRO', __FILE__ );
		define( 'CODESIGNER_PRO_DIR', dirname( CODESIGNER_PRO ) );
		define( 'CODESIGNER_PRO_ASSETS', plugins_url( 'assets', CODESIGNER_PRO ) );
		define( 'CODESIGNER_PRO_DEBUG', apply_filters( 'codesigner-pro_debug', true ) );

		/**
		 * The plugin data
		 * 
		 * @since 0.9
		 * @var $plugin
		 */
		$this->plugin					= get_plugin_data( CODESIGNER_PRO );
		$this->plugin['basename']		= plugin_basename( CODESIGNER_PRO );
		$this->plugin['file']			= CODESIGNER_PRO;
		$this->plugin['server']			= apply_filters( 'thumbpress-pro_server', 'https://my.pluggable.io' );
		$this->plugin['doc_id']			= 1960;
		$this->plugin['icon']			= CODESIGNER_PRO_ASSETS . '/img/icon.png';
		$this->plugin['depends']		= [ 'woolementor/codesigner.php' => 'CoDesigner' ];
		
		/**
		 * Pro version info
		 * 
		 * Applicable if this plugin has a pro version
		 */
		$this->plugin['item_id']		= 227;
		$this->plugin['license']		= new License( CODESIGNER_PRO, [
			'item_id'	=> $this->plugin['item_id'],
			'server'	=> $this->plugin['server'],
			'redirect'	=> admin_url( 'admin.php?page=codesigner-pro' )
		] );

		global $codesigner_pro;
		$codesigner_pro = $this->plugin;
	}

	/**
	 * Hooks
	 * 
	 * @access private
	 * 
	 * Executes main plugin features
	 *
	 * To add an action, use $instance->action()
	 * To apply a filter, use $instance->filter()
	 * To register a shortcode, use $instance->register()
	 * To add a hook for logged in users, use $instance->priv()
	 * To add a hook for non-logged in users, use $instance->nopriv()
	 * 
	 * @return void
	 */
	private function hook() {

		if( is_admin() ) :

			/**
			 * The installer
			 */
			$installer = new App\Installer( $this->plugin );
			$installer->activate( 'install' );
			$installer->deactivate( 'uninstall' );
			$installer->action( 'admin_footer', 'update' );

			/**
			 * Admin facing hooks
			 */
			$admin = new App\Admin( $this->plugin );
			$admin->action( 'admin_footer', 'modal' );
			$admin->action( 'plugins_loaded', 'i18n' );
			$admin->action( 'admin_head', 'head' );
			$admin->action( 'admin_enqueue_scripts', 'enqueue_scripts' );
			$admin->filter( 'codesigner-widget_links', 'widget_links' );	
			$admin->filter( 'plugin_row_meta', 'plugin_row_meta', 10, 2 );
			$admin->action( 'save_post', 'update_cache', 10, 3 );
			$admin->action( 'admin_footer_text', 'footer_text' );
			$admin->filter( 'woocommerce_payment_gateway_supports', 'supports_payment_form', 10, 3 );			
			$admin->filter( 'wcd_pro_get_posts', 'pseudo_page_ids' );
			$admin->filter( 'cx-plugin_remote_notice_endpoint', '__return_false', 10, 2 );
			$admin->action( 'admin_init', 'attribute_color_field' );
			// $admin->action( 'admin_notices', 'admin_notice' );
			
			/**
			 * Settings related hooks
			 */
			$settings = new App\Settings( $this->plugin );
			$settings->filter( 'codesigner-is_pro', '__return_true' );
			$settings->filter( 'codesigner-settings_args', 'settings_fields' );
			$settings->filter( 'codesigner-pro_settings_args', 'pro_settings_fields' );

			/**
			 * Renders different notices
			 * 
			 * @package Codexpert\Plugin
			 * 
			 * @author Codexpert <hi@codexpert.io>
			 */
			$notice = new Notice( $this->plugin );

			/**
			 * Shows a popup window asking why a user is deactivating the plugin
			 * 
			 * @package Pluggable\Marketing
			 * 
			 * @version 3.12
			 * 
			 * @author Codexpert <hi@codexpert.io>
			 */
			$deactivator = new Deactivator( CODESIGNER_PRO, [
				'server'	=> $this->plugin['server']
			] );

			/**
			 * Alters featured plugins
			 * 
			 * @package Pluggable\Marketing
			 * 
			 * @version 3.12
			 * 
			 * @author Codexpert <hi@codexpert.io>
			 */
			$feature = new Feature( CODESIGNER_PRO );

		else : // !is_admin() ?

			/**
			 * Front facing hooks
			 */
			$front = new App\Front( $this->plugin );
			$front->action( 'wp_head', 'head' );
			$front->action( 'wp_footer', 'footer' );
			$front->action( 'wp_enqueue_scripts', 'enqueue_scripts' );			
			$front->action( 'init', 'set_cookie' );	

			$front->filter( 'the_content', 'filter_content' );
			$front->filter( 'template_include', 'override_product_templates', 11 );
			$front->filter( 'woocommerce_checkout_fields', 'filter_checkout_fields' );
			$front->action( 'woocommerce_checkout_create_order', 'save_additional_fields', 10, 2 );
			
			$front->filter( 'woocommerce_is_checkout', 'is_checkout_render' );
			$front->action( 'woocommerce_checkout_redirect_empty_cart', 'empty_cart_render' );
			$front->action( 'woocommerce_checkout_update_order_review_expired', '__return_false' );
			// Filter for Floating Cart Fragments
			$front->filter( 'woocommerce_add_to_cart_fragments', 'floating_cart_fragments', 10, 2 );

		endif;

		/**
		 * Widgets related hooks
		 */
		$widgets = new App\Widgets( $this->plugin );
		$widgets->action( 'elementor/editor/after_enqueue_scripts', 'enqueue_scripts' );
		$widgets->action( 'elementor/element/after_section_end', 'add_control', 10, 3 );
		$widgets->action( 'elementor/frontend/section/before_render', 'form_start' );
		$widgets->action( 'elementor/frontend/section/after_render', 'form_close' );
		$widgets->filter( 'elementor/frontend/section/should_render', 'stop_render_checkout', 10, 2 );
		$widgets->action( 'init', 'order_received_permalink' );
		// $widgets->action( 'wp', 'setcookie_pageid' );
		$widgets->action( 'elementor/documents/register', 'register_type' );
		$widgets->action( 'elementor/template-library/create_new_dialog_types', 'template_types', 10, 2 );
		$widgets->action( 'elementor/documents/register_controls', 'conditions_for_templates' );
		$widgets->action( 'save_post', 'save_template_meta' );
		$widgets->filter( 'single_template', 'load_canvas_template' );
		$widgets->filter( 'woocommerce_add_to_cart_fragments', 'menu_cart' );
		$widgets->action( 'init', 'show_custom_checkout_fields' );
		$widgets->filter( 'wcd_register_widget', 'filter_widget', 10, 2 );
		$widgets->action( 'elementor/element/after_section_end', 'remove_controls', 10, 3 );

		$widgets->action( 'elementor/element/common/_section_style/before_section_start', 'register_control_section' );
		$widgets->action( 'elementor/element/column/layout/after_section_end', 'register_control_section' );
		$widgets->action( 'elementor/element/section/section_typo/after_section_end', 'register_control_section' );

		$widgets->action( 'elementor/element/common/codesigner_control_section/before_section_end', 'control_actions', 10, 2 );
		$widgets->action( 'elementor/element/column/codesigner_control_section/before_section_end', 'control_actions', 10, 2 );
		$widgets->action( 'elementor/element/section/codesigner_control_section/before_section_end', 'control_actions', 10, 2 );
		$widgets->filter( 'elementor/frontend/section/should_render', 'restrict_render_section', 10, 2 );
		$widgets->filter( 'elementor/frontend/column/should_render', 'restrict_render_section', 10, 2 );
		$widgets->filter( 'elementor/widget/render_content', 'restrict_render_widgets', 10, 2 );

		$widgets->action( 'init', 'register_custom_endpoint' );

		$widgets->action( 'codesigner_before_cart_button', 'quick_view_button', 10, 3 );
		$widgets->action( 'codesigner_before_cart_button', 'quick_checkout_button', 10, 3 );
		// $widgets->action( 'codesigner_after_cart_button', 'quick_view_button', 10, 3 );
		$widgets->action( 'codesigner_after_shop_content_controls', 'quickview_controls' );
		$widgets->action( 'codesigner_after_shop_style_controls', 'quickview_style_controls' );
		$widgets->action( 'codesigner_quick_checkout', 'quick_checkout_render' );
		// order pay button html
		$widgets->filter( 'woocommerce_order_button_html', 'order_button_html' );

		/**
		 * Cron facing hooks
		 */
		$cron = new App\Cron( $this->plugin );
		$cron->activate( 'install' );
		$cron->deactivate( 'uninstall' );

		/**
		 * Common hooks
		 *
		 * Executes on both the admin area and front area
		 */
		$common = new App\Common( $this->plugin );
		$common->action( 'pre_get_posts', 'ajax_filter_pre_posts' );
		$common->filter( 'my_plugin_pre_get_posts', 'ajax_filter_pre_posts' );

		/**
		 * AJAX related hooks
		 */
		$ajax = new App\AJAX( $this->plugin );
		$ajax->priv( 'some-route', 'some_callback' );
		$ajax->all( 'afp-form-submission', 'afp_form_submission' );
		$ajax->all( 'add-to-compare', 'add_to_compare' );
		$ajax->all( 'remove-from-compare', 'remove_from_compare' );
		$ajax->all( 'quick-view', 'quick_view' );
		$ajax->all( 'quick-checkout', 'quick_checkout' );
		$ajax->all( 'ajax-filter', 'ajax_filter' );
		$ajax->all( 'wl-quantatity-change', 'floating_widget_cart_quantatity' );
		$ajax->all( 'co-remove-item', 'floating_cartremove_item' );
		$ajax->all( 'co-apply-coupon', 'floating_cart_apply_coupon' );

		/**
		 * Theme_Support related hooks
		 *
		 * @since 1.0
		 */
		$theme_support = new App\Theme_Support( $this->plugin );

	}

	/**
	 * Cloning is forbidden.
	 * 
	 * @access public
	 */
	public function __clone() { }

	/**
	 * Unserializing instances of this class is forbidden.
	 * 
	 * @access public
	 */
	public function __wakeup() { }

	/**
	 * Instantiate the plugin
	 * 
	 * @access public
	 * 
	 * @return $_instance
	 */
	public static function instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}
}

Plugin::instance();