<?php
/**
 * All public facing functions
 */
namespace Codexpert\CoDesigner_Pro\App;
use Codexpert\Plugin\Base;
use Codexpert\CoDesigner_Pro\Helper;
use Mpdf\Mpdf;

/**
 * if accessed directly, exit.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * @package Plugin
 * @subpackage Front
 * @author Codexpert <hi@codexpert.io>
 */
class Front extends Base {

	public $plugin;
	public $slug;
	public $name;
	public $version;

	/**
	 * Constructor function
	 */
	public function __construct( $plugin ) {
		$this->plugin	= $plugin;
		$this->slug		= $this->plugin['TextDomain'];
		$this->name		= $this->plugin['Name'];
		$this->version	= $this->plugin['Version'];
	}

	public function head() {}
	
	/**
	 * Enqueue JavaScripts and stylesheets
	 */
	public function enqueue_scripts() {
		$min = defined( 'CODESIGNER_PRO_DEBUG' ) && CODESIGNER_PRO_DEBUG ? '' : '.min';

		wp_enqueue_style( $this->slug, plugins_url( "/assets/css/front{$min}.css", CODESIGNER_PRO ), '', $this->version, 'all' );

		wp_enqueue_script( $this->slug, plugins_url( "/assets/js/front{$min}.js", CODESIGNER_PRO ), [ 'jquery' ], $this->version, true );
		
		$localized = [
			'ajaxurl'		=> admin_url( 'admin-ajax.php' ),
			'_nonce'		=> wp_create_nonce( $this->slug ),
			'rest_nonce'	=> wp_create_nonce( 'wp_rest' ),
		];
		wp_localize_script( $this->slug, 'CODESIGNER_PRO', apply_filters( "{$this->slug}-localized", $localized ) );
	}	
	
	/*public function modal() {
		echo '
		<div id="codesigner-pro-modal" style="display: none">
			<img id="codesigner-pro-modal-loader" src="' . esc_attr( CODESIGNER_PRO_ASSETS . '/img/loader.gif' ) . '" />
		</div>';
	}*/

	public function set_cookie() {
		if ( isset( $_GET['products'] ) && $_GET['products'] != '' ) {			
	        $products 			= isset( $_GET['products'] ) ? $_GET['products'] : [];
			wcd_add_to_compare( $products );
		}
	}

	public function filter_content( $content ) {
		
		if ( 'elementor_canvas' !== get_page_template_slug() ) {
			return $content;
		}

		$header = $footer = '';

		$template_id = wcd_get_archive_template_id( 'wl-header' );
		if ( !is_null( $template_id ) ) {
			$elementor_instance = \Elementor\Plugin::instance();
			$header = $elementor_instance->frontend->get_builder_content_for_display( $template_id );
		}

		$template_id = wcd_get_archive_template_id( 'wl-footer' );
		if ( !is_null( $template_id ) ) {
			$elementor_instance = \Elementor\Plugin::instance();
			$footer = $elementor_instance->frontend->get_builder_content_for_display( $template_id );
		}

		return $header . $content . $footer;
	}

	public function override_product_templates( $template ) {
		$object = get_queried_object();
		
		if ( is_null( $object ) && ( !is_home() || !is_front_page() ) ) return $template;

		if ( is_home() || is_front_page() ) {
			$screen = 'page';
		}
		elseif ( function_exists( 'is_shop' ) && is_shop() ) {
			$screen = 'page';
		}
		elseif ( is_tax() ) {
			$screen = 'tax';
		}
		elseif ( is_singular() ) {
			$screen = $object->post_type;
		}
		else{
			$screen = $object->post_type;
		}

		$basename 		= basename( $template );
		$template_type  = $basename == 'single-product.php' ? 'wl-single' : 'wl-archive';
		$template_id 	= wcd_get_archive_template_id( $template_type );

		$template_meta 	= get_post_meta( $template_id, "wl_{$screen}_includes", true );

		if( !is_array( $template_meta ) || count( $template_meta ) <= 0 ) return $template;

		if ( is_shop() || is_tax() ) {
			return trailingslashit( CODESIGNER_PRO_DIR ) . "views/templates/archive.php";
		}
		elseif ( is_singular() ) {
			return trailingslashit( CODESIGNER_PRO_DIR ) . "views/templates/single-product.php";
		}
	}

	public function filter_checkout_fields( $fields ) {

		// get woocommerce checkout page ID
		$post_id 	= get_option( 'woocommerce_checkout_page_id' );
		$post 		= get_post( $post_id );
		$checkout_builder_page_id = get_option( 'codesigner_checkout_builder_page_id' );

		if ( wcd_is_edit_mode() || wcd_is_preview_mode() || ( $checkout_builder_page_id == $post_id ) || ( $post_id == get_the_ID() && isset( $post->post_content ) && has_shortcode( $post->post_content, 'woocommerce_checkout' ) ) ) return $fields;

		$_wl_fields = get_option( '_wcd_checkout_fields', [] );

		if( count( $_wl_fields ) <= 0 ) return $fields;

		$wl_ids 		 = [];
		$checkout_fields = [];
		foreach ( $_wl_fields as $section => $checkout_section_fields ) {
			if ( in_array( $section, [ 'billing', 'shipping', 'order' ] ) && ! empty( $checkout_section_fields ) ) {
				foreach( $checkout_section_fields as $item ) {	
					$wl_ids[] = $item[ "{$section}_input_name" ];
					$checkout_fields[$section][ sanitize_text_field( $item["{$section}_input_name"] ) ] = 
				        [
				            'label'			=> sanitize_text_field( $item["{$section}_input_label"] ),
				            'type'			=> esc_attr( $item["{$section}_input_type"] ),
				            'required'		=> $item["{$section}_input_required"] == 'true' ? true : false,
				            'class'			=> is_array( $item["{$section}_input_class"] ) ? $item["{$section}_input_class"] : explode( ' ', $item["{$section}_input_class"] ),
				            'autocomplete'	=> sanitize_text_field( $item["{$section}_input_autocomplete"] ), 
				            'placeholder'	=> sanitize_text_field( $item["{$section}_input_placeholder"] ),
				            'priority'		=> 10,
				        ];
				}
			}
		}

		$fields = $checkout_fields + $fields;		

		foreach ( $fields as $section => $section_fields ) {
			foreach ( $section_fields as $key => $value ) {
				if ( !in_array( $key, $wl_ids ) ) {
					unset( $fields[ $section ][ $key ] );
				}
			
			}
		}

		return $fields;
	}

	public function is_checkout_render() {
		global $post;

		if ( is_singular() ) {
			$post_id = $post->ID;
			if ( get_post_meta( $post_id, 'codesigner_quick_checkout', true ) ) {
				return true;
			}
		}
		
		return false;
	}

	public function empty_cart_render() {
		global $post;

		$post_id = $post->ID;
		if ( get_post_meta( $post_id, 'codesigner_quick_checkout', true ) ) {
			return false;
		}
		return true;
	}

	public function footer() {
		?>
		<div class="wcd-quick-view-modal" style="display: none;">
			<div class="wcd-quick-view-modal-overlay wcd-quick-view-wrap"></div>
			<div class="wcd-quick-view-loader" style="display: none;"></div>
			<div class="wcd-quick-view-modal-wrapper wcd-quick-view-modal-transition">
				<div class="wcd-quick-view-modal-inner">
					<div class="wcd-quick-view-modal-header">
						<button class="wcd-quick-view-modal-close wcd-quick-view-wrap">x</button>
						<h2 class="wcd-quick-view-modal-heading"><?php _e( 'Product title goes here', 'codesigner-pro' ); ?></h2>
					</div>

					<div class="wcd-quick-view-modal-body">
						<div class="wcd-quick-view-modal-content">
							<p><?php _e( 'Please select a template first', 'codesigner-pro' ); ?></p>
						</div>
					</div>
				</div>
			</div>
		</div>

		<div class="wcd-loader-wrapper" style="display: none;">
			<div class="wcd-loader"></div>
		</div>
		<?php
	}

	public function save_additional_fields( $order, $data ) {
		$posted = $_POST;

		if( isset( $posted['woocommerce-process-checkout-nonce'] ) ) unset( $posted['woocommerce-process-checkout-nonce'] );
		if( isset( $posted['_wp_http_referer'] ) ) unset( $posted['_wp_http_referer'] );
		
		$wc_fields 		= wcd_wc_fields();
		$default_fields = array_merge( $wc_fields['billing'], $wc_fields['shipping'], $wc_fields['order'] );

		foreach ( $posted as $key => $value ) {
			if( ! in_array( $key, $default_fields ) ) {
				$order->update_meta_data( sanitize_text_field( $key ), sanitize_text_field( $value ) );
			}
		}

		$note = isset( $posted['order_comments'] ) ? $posted['order_comments'] : '';

		// Add the note
		$order->add_order_note( $note );
	    $order->set_customer_note( $note );
	    $order->save();
	}
	
	/**
	 * floating fragments sent to cart
	 */
	public function floating_cart_fragments( $fragments ){
		global $woocommerce;
		$products 		= [];
    	$cart 			= WC()->cart;
		$cartQuantity 	= $cart->get_cart_contents_count();
		$cart_products 	= $cart->get_cart();
		$totalamount 	= $woocommerce->cart->get_cart_total();
		$checkout 		= wc_get_checkout_url();
	
		$fragments['wl-checkout-amount'] = '<div class="wl-floating-cart-footer">
					<a href="'.wc_get_checkout_url().'" class="wl-floating-cart-checkout wl-floating-cart-btn">					
					<div class="wl-floating-cart-footer-icon">
						<span class="wl-floating-cart-footer-label">Checkout</span>
						<span class="wl-floating-cart-dash">-</span>
						<span class="wl-amount">'. WC()->cart->get_total() .'</span>
					</div>
					</a> 			
				</div>';

		foreach ( $cart_products as $key => $cart ) {
			$product_id 		= $cart['product_id'];
			$product 			= wc_get_product( $product_id );
			// Get the product image URL.
			$image_url_array 	= wp_get_attachment_image_src(get_post_thumbnail_id( $product_id ), 'single-post-thumbnail' );
			$product_image_url	= $image_url_array[0];
			$permalink 			= get_permalink( $product_id );

			$products[ $cart['product_id'] ] 	= [
				'name' 		=> $product->get_title(), 
				'key' 		=> $cart['key'], 
				'data_hash' => $cart['data_hash'], 
				'line_total'=> $cart['line_total'], 
				'quantity'	=> $cart['quantity'], 
				'product_id'=> $cart['product_id'], 
				'product_image'=> $product_image_url,
				'url'		=> $permalink,
			];			
		}		

		foreach ( $products as $key => $item ) {				
			$html[] = '
				<tr class="wl-floating-product wl-floating-simple" data-key="'. $item['key'] . '" data-id="'.$item['product_id'].'">
					<td class="wl-floating-product-image">
						<a href="'.$item['url'].'">
							<img  src="'.$item['product_image'].'" class="attachment-woocommerce_thumbnail size-woocommerce_thumbnail" alt="'.$item['name'].'" >
						</a>
					</td>
					<td class="wl-floating-product-details">
						<span class="wl-floating-product-title">
							<a class="wl-floating-product-title-inner" href="'.$item['url'].'">'.$item['name'].'</a>
						</span>
						<div class="wl-floating-quantity-row">
							<span class="wl-floating-quantity-col wl-floating-quantity-col-minus" data-action="decrement">
								<i class="fa fa-minus" aria-hidden="true"></i>
							</span>
							<span class="wl-floating-quantity-col wl-floating-quantity-col-input">
								<input type="number" class="wl-fc-input-text qty text" step="1" min="1" max="" 
								value="'.$item['quantity'].'" data-key="'. $item['key'] .'" title="Qty" placeholder="" inputmode="numeric">
							</span>											
							<span class="wl-floating-quantity-col wl-floating-quantity-col-plus" data-action="increment">
								<i class="fa fa-plus" aria-hidden="true"></i>
							</span>
						</div>
					</td>
					<td>
						<span class="wl-floating-price amount" data-key="'.$item['key'] .'" >
							<span class="woocommerce-Price-currencySymbol">$</span>'.$item['line_total'].'</bdi>
						</span>
						<span class="wl-fc-remove">Remove</span>
					</td>
				</tr>';
		};

		$fragments['wl-cart-product'] 	= $html;	
		$fragments['wl-cart-quentity'] 	= $cartQuantity;	
		

		return $fragments;
	}
}