<?php

namespace ElementPack\Modules\WcProducts;

use ElementPack\Base\Element_Pack_Module_Base;

if ( ! defined( 'ABSPATH' ) )
	exit; // Exit if accessed directly

class Module extends Element_Pack_Module_Base {

	public function __construct() {

		parent::__construct();

		if ( ! empty( $_REQUEST['action'] ) && 'elementor' === $_REQUEST['action'] && is_admin() ) {
			add_action( 'init', [ $this, 'register_wc_hooks' ], 5 );
		}

		add_action( 'elementor/editor/before_enqueue_scripts', [ $this, 'maybe_init_cart' ] );

		/**
		 * Modal data
		 */
		add_action( 'wp_ajax_nopriv_element_pack_wc_product_quick_view_content', [ $this, 'element_pack_wc_product_quick_view_content' ] );
		add_action( 'wp_ajax_element_pack_wc_product_quick_view_content', [ $this, 'element_pack_wc_product_quick_view_content' ] );

		/**
		 * Product post class
		 */
		add_action( 'element_pack_wc_product_quick_view_data', 'woocommerce_template_single_title' );
		add_action( 'element_pack_wc_product_quick_view_data', 'woocommerce_template_single_rating' );
		add_action( 'element_pack_wc_product_quick_view_data', 'woocommerce_template_single_price' );
		add_action( 'element_pack_wc_product_quick_view_data', 'woocommerce_template_single_excerpt' );
		add_action( 'element_pack_wc_product_quick_view_data', 'woocommerce_template_single_add_to_cart' );
		add_action( 'element_pack_wc_product_quick_view_data', 'woocommerce_template_single_meta' );
		add_action( 'element_pack_wc_product_quick_view_product_sale_flash', 'woocommerce_show_product_sale_flash' );
		add_action( 'element_pack_woocommerce_show_product_images', [ $this, 'element_pack_woocommerce_show_product_images' ] );

		/**
		 * Ajax load more
		 */

		add_action( 'wp_ajax_nopriv_bdt_ep_wc_products_load_more', [ $this, 'callback_ajax_loadmore_wc_products' ] );
		add_action( 'wp_ajax_bdt_ep_wc_products_load_more', [ $this, 'callback_ajax_loadmore_wc_products' ] );
	}

	public function get_name() {
		return 'wc-products';
	}

	public function get_widgets() {

		$widgets = [ 'WC_Products' ];

		return $widgets;
	}

	public function add_products_post_class_filter() {
		add_filter( 'post_class', [ $this, 'add_product_post_class' ] );
	}

	public function remove_products_post_class_filter() {
		remove_filter( 'post_class', [ $this, 'add_product_post_class' ] );
	}

	public function register_wc_hooks() {
		wc()->frontend_includes();
	}

	public function maybe_init_cart() {
		$has_cart = is_a( WC()->cart, 'WC_Cart' );

		if ( ! $has_cart ) {
			$session_class = apply_filters( 'woocommerce_session_handler', 'WC_Session_Handler' );
			WC()->session  = new $session_class();
			WC()->session->init();
			WC()->cart     = new \WC_Cart();
			WC()->customer = new \WC_Customer( get_current_user_id(), true );
		}
	}

	public function element_pack_wc_product_quick_view_content                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      